/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class TeleportCommand
extends Command {
    public TeleportCommand() {
        super("tp", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        System.out.println("TP Command");
        System.out.println("handler: " + handler);
        System.out.println("sender: " + sender);
        boolean sentByPlayer = sender instanceof PlayerCommandSender;
        if (args.length > 0) {
            if (args.length <= 2) {
                EntityPlayer from = null;
                EntityPlayer to = null;
                if (args.length == 1) {
                    if (sentByPlayer) {
                        from = sender.getPlayer();
                        to = this.getPlayer(handler, args[0]);
                    } else {
                        return false;
                    }
                }
                if (args.length == 2) {
                    from = this.getPlayer(handler, args[0]);
                    to = this.getPlayer(handler, args[1]);
                }
                TeleportCommand.teleport(handler, sender, from, to);
                return true;
            }
            EntityPlayer player = null;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (args.length == 3 && sentByPlayer) {
                x = this.parseDouble(args[0]);
                y = this.parseDouble(args[1]);
                z = this.parseDouble(args[2]);
                player = sender.getPlayer();
            }
            if (args.length == 4) {
                player = this.getPlayer(handler, args[0]);
                x = this.parseDouble(args[1]);
                y = this.parseDouble(args[2]);
                z = this.parseDouble(args[3]);
            }
            x = MathHelper.clamp(x, -3.2E7, 3.2E7);
            z = MathHelper.clamp(z, -3.2E7, 3.2E7);
            TeleportCommand.teleport(handler, sender, player, null, x, y, z, player.yRot, player.xRot, null);
            return true;
        }
        return false;
    }

    public double parseDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception e) {
            throw new CommandError("Not a number: \"" + str + "\"");
        }
    }

    public EntityPlayer getPlayer(CommandHandler handler, String name) {
        EntityPlayer player = handler.getPlayer(name);
        if (player == null) {
            throw new CommandError("Player not found: " + name);
        }
        return player;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        boolean server = handler instanceof ServerCommandHandler;
        boolean sentByPlayer = sender instanceof PlayerCommandSender;
        if (server) {
            sender.sendMessage("/tp <FromPlayer> <ToPlayer>");
        }
        if (sentByPlayer && server) {
            sender.sendMessage("/tp <ToPlayer>");
        }
        if (server) {
            sender.sendMessage("/tp <Player> <x> <y> <z>");
        }
        if (sentByPlayer) {
            sender.sendMessage("/tp <x> <y> <z>");
        }
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    public static void teleport(CommandHandler handler, CommandSender sender, EntityPlayer p1, Integer dimension, double x, double y, double z, double yaw, double pitch, EntityPlayer p2) {
        if (p1 instanceof EntityPlayerMP) {
            EntityPlayerMP p1MP = (EntityPlayerMP)p1;
            if (dimension != null && p1MP.dimension != dimension && handler instanceof ServerCommandHandler) {
                ServerCommandHandler serverCommandHandler = (ServerCommandHandler)handler;
                serverCommandHandler.minecraftServer.playerList.sendPlayerToOtherDimension(p1MP, dimension, false);
            }
            p1MP.playerNetServerHandler.teleportAndRotate(x, y, z, p1MP.yRot, p1MP.xRot);
        } else {
            p1.absMoveTo(x, y, z, p1.yRot, p1.xRot);
        }
        if (p2 != null) {
            handler.sendCommandFeedback(sender, "Teleporting " + p1.getDisplayName() + TextFormatting.WHITE + " to " + p2.getDisplayName());
        } else {
            handler.sendCommandFeedback(sender, "Teleporting " + p1.getDisplayName() + TextFormatting.WHITE + " to x: " + TeleportCommand.floor10(x) + " y: " + TeleportCommand.floor10(y) + " z: " + TeleportCommand.floor10(z));
        }
    }

    public static void teleport(CommandHandler handler, CommandSender sender, EntityPlayer p1, EntityPlayer p2) {
        TeleportCommand.teleport(handler, sender, p1, p2.dimension, p2.x, p2.y, p2.z, p2.yRot, p2.xRot, p2);
    }

    public static double floor10(double a) {
        return (double)((int)(a * 10.0)) / 10.0;
    }
}

