/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.weather;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.weather.WeatherClear;
import net.minecraft.core.world.weather.WeatherRain;
import net.minecraft.core.world.weather.WeatherSnow;
import net.minecraft.core.world.weather.WeatherStorm;

public abstract class Weather {
    public int weatherId;
    public String languageKey;
    public boolean isPrecipitation = false;
    private String texturePath = null;
    public int subtractLightLevel = 0;
    public int precipitationType = 0;
    public boolean spawnRainParticles = false;
    public boolean doMobsSpawnInDaylight = false;
    public boolean isDamp = false;
    public float fogDistance = 1.0f;
    public static final Weather[] weatherList = new Weather[16];
    public static final Weather overworldClear = new WeatherClear(0).setLanguageKey("overworld.clear");
    public static final Weather overworldRain = new WeatherRain(1).setLanguageKey("overworld.rain").setPrecipitation("/environment/rain.png", 0).setSubtractLightLevel(3).setSpawnRainParticles(true).setFogDistance(0.5f).setDamp();
    public static final Weather overworldSnow = new WeatherSnow(2).setLanguageKey("overworld.snow").setPrecipitation("/environment/snow.png", 1).setSubtractLightLevel(1).setFogDistance(0.5f).setDamp();
    public static final Weather overworldStorm = new WeatherStorm(3).setLanguageKey("overworld.storm").setPrecipitation("/environment/rain.png", 0).setSubtractLightLevel(5).setSpawnRainParticles(true).setMobsSpawnInDaylight().setFogDistance(0.4f).setDamp();
    public static final Weather overworldFog = new WeatherClear(4).setLanguageKey("overworld.fog").setFogDistance(0.125f);
    public static final Weather overworldHellClear = new WeatherClear(5).setLanguageKey("overworld.clear.hell").setSubtractLightLevel(7);
    public static final Weather overworldWoodsClear = new WeatherClear(6).setLanguageKey("overworld.clear.woods").setSubtractLightLevel(2);
    public static final Weather overworldWinterSnow = new WeatherSnow(7).setLanguageKey("overworld.winter.snow").setPrecipitation("/environment/snow.png", 1).setDamp();
    public static final Weather overworldRainBlood = new WeatherStorm(8).setLanguageKey("overworld.rain.blood").setPrecipitation("/environment/rain_blood.png", 2).setSubtractLightLevel(5).setMobsSpawnInDaylight().setFogDistance(0.4f).setDamp();

    public Weather(int id) {
        if (weatherList[id] != null) {
            throw new RuntimeException();
        }
        Weather.weatherList[id] = this;
        this.weatherId = id;
    }

    public Weather setLanguageKey(String key) {
        this.languageKey = "weather." + key;
        return this;
    }

    public Weather setPrecipitation(String texturePath, int type) {
        this.isPrecipitation = true;
        this.texturePath = texturePath;
        this.precipitationType = type;
        return this;
    }

    public Weather setPrecipitationTexture(String texturePath) {
        this.texturePath = texturePath;
        return this;
    }

    public String getPrecipitationTexture(World world) {
        return this.texturePath;
    }

    public Weather setSubtractLightLevel(int subtractLightLevel) {
        this.subtractLightLevel = subtractLightLevel;
        return this;
    }

    public Weather setSpawnRainParticles(boolean spawnRainParticles) {
        this.spawnRainParticles = spawnRainParticles;
        return this;
    }

    public Weather setFogDistance(float f) {
        this.fogDistance = f;
        return this;
    }

    public Weather setMobsSpawnInDaylight() {
        this.doMobsSpawnInDaylight = true;
        return this;
    }

    public Weather setDamp() {
        this.isDamp = true;
        return this;
    }

    public String getTranslatedName() {
        return I18n.getInstance().translateKey(this.languageKey + ".name");
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public float[] modifyFogColor(float r, float g, float b, float intensity) {
        return new float[]{r, g, b};
    }

    public void doEnvironmentUpdate(World world, Random rand, int x, int z) {
        if (world.getSeasonManager().getCurrentSeason() != null && !world.getSeasonManager().getCurrentSeason().letWeatherCleanUpSnow) {
            return;
        }
        if (rand.nextInt(4) == 0) {
            int y = world.getHeightValue(x, z);
            int blockId = world.getBlockId(x, y, z);
            int blockIdBelow = world.getBlockId(x, y - 1, z);
            if (world.getBlockBiome(x, y, z).hasSurfaceSnow()) {
                int meta;
                if (blockId == Block.layerSnow.id && (meta = world.getBlockMetadata(x, y, z)) != 0) {
                    world.setBlockMetadata(x, y, z, meta - 1);
                    world.markBlockNeedsUpdate(x, y, z);
                }
            } else if (blockId == Block.layerSnow.id) {
                int meta = world.getBlockMetadata(x, y, z);
                if (meta != 0) {
                    world.setBlockMetadata(x, y, z, meta - 1);
                    world.markBlockNeedsUpdate(x, y, z);
                } else {
                    world.setBlockWithNotify(x, y, z, 0);
                }
            } else if (blockIdBelow == Block.ice.id) {
                world.setBlockWithNotify(x, y - 1, z, Block.fluidWaterStill.id);
            }
        }
    }

    public void doChunkLoadEffect(World world, Chunk chunk) {
        if (world.getSeasonManager().getCurrentSeason() != null && !world.getSeasonManager().getCurrentSeason().letWeatherCleanUpSnow) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = chunk.getHeightValue(x, z);
                if (y == 0) continue;
                int blockId = chunk.getBlockID(x, y, z);
                int blockIdBelow = chunk.getBlockID(x, y - 1, z);
                if (world.getBlockBiome(chunk.xPosition * 16 + x, y, chunk.zPosition * 16 + z).hasSurfaceSnow()) {
                    if (blockId != Block.layerSnow.id) continue;
                    chunk.setBlockMetadata(x, y, z, 0);
                    continue;
                }
                if (blockId == Block.layerSnow.id) {
                    chunk.setBlockID(x, y, z, 0);
                    continue;
                }
                if (blockIdBelow != Block.ice.id) continue;
                chunk.setBlockID(x, y - 1, z, Block.fluidWaterStill.id);
            }
        }
    }

    public static Weather getWeatherByLanguageKey(String string) {
        for (Weather weather : weatherList) {
            if (weather == null || !weather.languageKey.substring(8).equalsIgnoreCase(string)) continue;
            return weather;
        }
        return null;
    }

    public static Weather getWeather(int i) {
        return weatherList[i];
    }
}

