/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.player;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet50PreChunk;
import net.minecraft.core.net.packet.Packet51MapChunk;
import net.minecraft.core.net.packet.Packet52MultiBlockChange;
import net.minecraft.core.net.packet.Packet53BlockChange;
import net.minecraft.core.player.PlayerHash;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;
import net.minecraft.server.world.WorldServer;

public class PlayerManager {
    public final List<EntityPlayerMP> players;
    private final PlayerHash playerInstances;
    private final List<PlayerInstance> playerInstancesToUpdate;
    private final MinecraftServer server;
    private final int dimension;
    private final int viewRadius;
    private final int[][] field_22089_e = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};

    public PlayerManager(MinecraftServer server, int dimension, int viewRadius) {
        this.players = new ArrayList<EntityPlayerMP>();
        this.playerInstances = new PlayerHash();
        this.playerInstancesToUpdate = new ArrayList<PlayerInstance>();
        if (viewRadius > 15) {
            throw new IllegalArgumentException("Too big view radius!");
        }
        if (viewRadius < 3) {
            throw new IllegalArgumentException("Too small view radius!");
        }
        this.viewRadius = viewRadius;
        this.server = server;
        this.dimension = dimension;
    }

    public void tick() {
        for (PlayerInstance playerInstance : this.playerInstancesToUpdate) {
            playerInstance.tick();
        }
        this.playerInstancesToUpdate.clear();
    }

    private PlayerInstance getPlayerInstance(int chunkX, int chunkZ, boolean makeNewIfAbsent) {
        long key = (long)chunkX + Integer.MAX_VALUE | (long)chunkZ + Integer.MAX_VALUE << 32;
        PlayerInstance instance = (PlayerInstance)this.playerInstances.getValueByKey(key);
        if (instance == null && makeNewIfAbsent) {
            instance = new PlayerInstance(chunkX, chunkZ);
            this.playerInstances.add(key, instance);
        }
        return instance;
    }

    public void markBlockNeedsUpdate(int x, int y, int z) {
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        PlayerInstance instance = this.getPlayerInstance(xChunk, zChunk, false);
        if (instance != null) {
            instance.markBlockNeedsUpdate(x & 0xF, y, z & 0xF);
        }
    }

    public void addPlayer(EntityPlayerMP player) {
        int xChunk = (int)player.x >> 4;
        int zChunk = (int)player.z >> 4;
        player.field_9155_d = player.x;
        player.field_9154_e = player.z;
        int k = 0;
        int radius = this.viewRadius;
        int dx = 0;
        int dz = 0;
        this.getPlayerInstance(xChunk, zChunk, true).addPlayer(player);
        for (int k1 = 1; k1 <= radius * 2; ++k1) {
            for (int i2 = 0; i2 < 2; ++i2) {
                int[] ai = this.field_22089_e[k++ % 4];
                for (int j2 = 0; j2 < k1; ++j2) {
                    this.getPlayerInstance(xChunk + (dx += ai[0]), zChunk + (dz += ai[1]), true).addPlayer(player);
                }
            }
        }
        k %= 4;
        for (int l1 = 0; l1 < radius * 2; ++l1) {
            this.getPlayerInstance(xChunk + (dx += this.field_22089_e[k][0]), zChunk + (dz += this.field_22089_e[k][1]), true).addPlayer(player);
        }
        this.players.add(player);
    }

    public void removePlayer(EntityPlayerMP entityplayermp) {
        int i = (int)entityplayermp.field_9155_d >> 4;
        int j = (int)entityplayermp.field_9154_e >> 4;
        for (int k = i - this.viewRadius; k <= i + this.viewRadius; ++k) {
            for (int l = j - this.viewRadius; l <= j + this.viewRadius; ++l) {
                PlayerInstance playerinstance = this.getPlayerInstance(k, l, false);
                if (playerinstance == null) continue;
                playerinstance.removePlayer(entityplayermp);
            }
        }
        this.players.remove(entityplayermp);
    }

    private boolean func_544_a(int i, int j, int k, int l) {
        int i1 = i - k;
        int j1 = j - l;
        if (i1 < -this.viewRadius || i1 > this.viewRadius) {
            return false;
        }
        return j1 >= -this.viewRadius && j1 <= this.viewRadius;
    }

    public void func_543_c(EntityPlayerMP entityplayermp) {
        int i = (int)entityplayermp.x >> 4;
        int j = (int)entityplayermp.z >> 4;
        double d = entityplayermp.field_9155_d - entityplayermp.x;
        double d1 = entityplayermp.field_9154_e - entityplayermp.z;
        double d2 = d * d + d1 * d1;
        if (d2 < 64.0) {
            return;
        }
        int k = (int)entityplayermp.field_9155_d >> 4;
        int l = (int)entityplayermp.field_9154_e >> 4;
        int i1 = i - k;
        int j1 = j - l;
        if (i1 == 0 && j1 == 0) {
            return;
        }
        for (int k1 = i - this.viewRadius; k1 <= i + this.viewRadius; ++k1) {
            for (int l1 = j - this.viewRadius; l1 <= j + this.viewRadius; ++l1) {
                PlayerInstance playerinstance;
                if (!this.func_544_a(k1, l1, k, l)) {
                    this.getPlayerInstance(k1, l1, true).addPlayer(entityplayermp);
                }
                if (this.func_544_a(k1 - i1, l1 - j1, i, j) || (playerinstance = this.getPlayerInstance(k1 - i1, l1 - j1, false)) == null) continue;
                playerinstance.removePlayer(entityplayermp);
            }
        }
        entityplayermp.field_9155_d = entityplayermp.x;
        entityplayermp.field_9154_e = entityplayermp.z;
    }

    public int getMaxTrackingDistance() {
        return this.viewRadius * 16 - 16;
    }

    class PlayerInstance {
        private final List<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
        private final int chunkX;
        private final int chunkZ;
        private final ChunkCoordinate currentChunk;
        private final int[] blocksToUpdate = new int[10];
        private int numBlocksToUpdate = 0;
        private int minX;
        private int maxX;
        private int minY;
        private int maxY;
        private int minZ;
        private int maxZ;

        public PlayerInstance(int chunkX, int chunkZ) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.currentChunk = new ChunkCoordinate(chunkX, chunkZ);
            ((PlayerManager)PlayerManager.this).server.getDimensionWorld((int)((PlayerManager)PlayerManager.this).dimension).chunkProviderServer.prepareChunk(chunkX, chunkZ);
        }

        public void addPlayer(EntityPlayerMP player) {
            if (this.players.contains(player)) {
                throw new IllegalStateException("Failed to add player. " + player + " already is in chunk " + this.chunkX + ", " + this.chunkZ);
            }
            player.field_420_ah.add(this.currentChunk);
            player.playerNetServerHandler.sendPacket(new Packet50PreChunk(this.currentChunk.x, this.currentChunk.z, true));
            this.players.add(player);
            player.loadedChunks.add(this.currentChunk);
        }

        public void removePlayer(EntityPlayerMP player) {
            if (!this.players.contains(player)) {
                return;
            }
            this.players.remove(player);
            if (this.players.isEmpty()) {
                long key = (long)this.chunkX + Integer.MAX_VALUE | (long)this.chunkZ + Integer.MAX_VALUE << 32;
                PlayerManager.this.playerInstances.remove(key);
                if (this.numBlocksToUpdate > 0) {
                    PlayerManager.this.playerInstancesToUpdate.remove(this);
                }
                ((PlayerManager)PlayerManager.this).server.getDimensionWorld((int)((PlayerManager)PlayerManager.this).dimension).chunkProviderServer.func_35391_d(this.chunkX, this.chunkZ);
            }
            player.loadedChunks.remove(this.currentChunk);
            if (player.field_420_ah.contains(this.currentChunk)) {
                player.playerNetServerHandler.sendPacket(new Packet50PreChunk(this.chunkX, this.chunkZ, false));
            }
        }

        public void markBlockNeedsUpdate(int x, int y, int z) {
            if (this.numBlocksToUpdate == 0) {
                PlayerManager.this.playerInstancesToUpdate.add(this);
                this.minX = this.maxX = x;
                this.minY = this.maxY = y;
                this.minZ = this.maxZ = z;
            }
            if (this.minX > x) {
                this.minX = x;
            }
            if (this.maxX < x) {
                this.maxX = x;
            }
            if (this.minY > y) {
                this.minY = y;
            }
            if (this.maxY < y) {
                this.maxY = y;
            }
            if (this.minZ > z) {
                this.minZ = z;
            }
            if (this.maxZ < z) {
                this.maxZ = z;
            }
            if (this.numBlocksToUpdate < 10) {
                int index = Chunk.makeBlockIndex(x, y, z);
                for (int i = 0; i < this.numBlocksToUpdate; ++i) {
                    if (this.blocksToUpdate[i] != index) continue;
                    return;
                }
                this.blocksToUpdate[this.numBlocksToUpdate++] = index;
            }
        }

        public void sendPacketToPlayersInInstance(Packet packet) {
            for (int i = 0; i < this.players.size(); ++i) {
                EntityPlayerMP entityplayermp = this.players.get(i);
                if (!entityplayermp.field_420_ah.contains(this.currentChunk)) continue;
                entityplayermp.playerNetServerHandler.sendPacket(packet);
            }
        }

        public void tick() {
            WorldServer world = PlayerManager.this.server.getDimensionWorld(PlayerManager.this.dimension);
            if (this.numBlocksToUpdate == 0) {
                return;
            }
            if (this.numBlocksToUpdate == 1) {
                int x = this.chunkX * 16 + this.minX;
                int y = this.minY;
                int z = this.chunkZ * 16 + this.minZ;
                this.sendPacketToPlayersInInstance(new Packet53BlockChange(x, y, z, world));
                if (Block.isEntityTile[world.getBlockId(x, y, z)]) {
                    this.updateTileEntity(world.getBlockTileEntity(x, y, z));
                }
            } else if (this.numBlocksToUpdate >= 10) {
                this.minY = this.minY / 2 * 2;
                this.maxY = (this.maxY / 2 + 1) * 2;
                int minWorldX = this.minX + this.chunkX * 16;
                int minWorldY = this.minY;
                int minWorldZ = this.minZ + this.chunkZ * 16;
                int xSize = this.maxX - this.minX + 1;
                int ySize = this.maxY - this.minY + 2;
                int zSize = this.maxZ - this.minZ + 1;
                this.sendPacketToPlayersInInstance(new Packet51MapChunk(minWorldX, minWorldY, minWorldZ, xSize, ySize, zSize, world));
                List<TileEntity> list = world.getTileEntityList(minWorldX, minWorldY, minWorldZ, minWorldX + xSize, minWorldY + ySize, minWorldZ + zSize);
                for (int j3 = 0; j3 < list.size(); ++j3) {
                    this.updateTileEntity(list.get(j3));
                }
            } else {
                this.sendPacketToPlayersInInstance(new Packet52MultiBlockChange(this.chunkX, this.chunkZ, this.blocksToUpdate, this.numBlocksToUpdate, world));
                for (int k = 0; k < this.numBlocksToUpdate; ++k) {
                    int x = this.chunkX * 16 + (this.blocksToUpdate[k] >> 0 & 0xF);
                    int y = this.blocksToUpdate[k] >> 8;
                    int z = this.chunkZ * 16 + (this.blocksToUpdate[k] >> 4 & 0xF);
                    if (!Block.isEntityTile[world.getBlockId(x, y, z)]) continue;
                    this.updateTileEntity(world.getBlockTileEntity(x, y, z));
                }
            }
            this.numBlocksToUpdate = 0;
        }

        private void updateTileEntity(TileEntity tileentity) {
            Packet packet;
            if (tileentity != null && (packet = tileentity.getDescriptionPacket()) != null) {
                this.sendPacketToPlayersInInstance(packet);
            }
        }
    }
}

