/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.error;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.enums.EnumGPUVendor;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ClickableLabelElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenMainMenu;
import net.minecraft.client.util.helper.UrlHelper;
import net.minecraft.core.lang.I18n;
import org.slf4j.Logger;

public class ScreenMissingJCE
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected ButtonElement continueButton = null;
    protected ButtonElement downloadButton = null;
    protected ButtonElement upgradeButton = null;

    @Override
    public void init() {
        I18n i = I18n.getInstance();
        this.buttons.clear();
        String downloadString = i.translateKey("gui.no_jce.button.download");
        String patchString = i.translateKey("gui.no_jce.button.upgrade");
        this.continueButton = this.add(new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 120 + 12, i.translateKey("gui.no_jce.button.continue")));
        this.downloadButton = this.add(new ClickableLabelElement(1, this.width / 2 - 170, this.height / 4 - 60 + 60 + 64, downloadString, 8165866));
        this.upgradeButton = this.add(new ClickableLabelElement(2, this.width / 2 - 170, this.height / 4 - 60 + 60 + 77, patchString, 8165866));
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.mc.displayScreen(new ScreenMainMenu());
        }
        if (button.id == 1) {
            UrlHelper.openURL("https://adoptium.net/en-GB/temurin/releases/?version=8");
        }
        if (button.id == 2) {
            UrlHelper.openURL("https://www.oracle.com/java/technologies/javase-jce-all-downloads.html");
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        I18n i = I18n.getInstance();
        this.renderBackground();
        this.drawStringCentered(this.font, i.translateKey("gui.no_jce.label.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.font, i.translateKey("gui.no_jce.label.body.1"), this.width / 2 - 170, this.height / 4 - 60 + 60, 0xA0A0A0);
        this.drawString(this.font, i.translateKey("gui.no_jce.label.body.2"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 18, 0xA0A0A0);
        this.drawString(this.font, i.translateKey("gui.no_jce.label.body.3"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 27, 0xA0A0A0);
        this.drawString(this.font, i.translateKey("gui.no_jce.label.body.4"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 45, 0xA0A0A0);
        this.drawString(this.font, i.translateKey("gui.no_jce.label.body.5"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 54, 0xA0A0A0);
        if (Minecraft.GPU_VENDOR == EnumGPUVendor.INTEL) {
            this.drawString(this.font, i.translateKey("gui.no_jce.label.body.intel.disclaimer.1"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 72, 0xA0A0A0);
            this.drawString(this.font, i.translateKey("gui.no_jce.label.body.intel.disclaimer.2"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 81, 0xA0A0A0);
            this.drawString(this.font, i.translateKey("gui.no_jce.label.body.intel.disclaimer.3"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 90, 0xA0A0A0);
            this.downloadButton.yPosition = this.height / 4 - 60 + 60 + 100;
            this.downloadButton.displayString = i.translateKey("gui.no_jce.button.download");
            this.upgradeButton.yPosition = this.height / 4 - 60 + 60 + 113;
            this.upgradeButton.displayString = i.translateKey("gui.no_jce.button.upgrade.recommended");
        } else {
            this.downloadButton.yPosition = this.height / 4 - 60 + 60 + 64;
            this.downloadButton.displayString = i.translateKey("gui.no_jce.button.download.recommended");
            this.upgradeButton.yPosition = this.height / 4 - 60 + 60 + 77;
            this.upgradeButton.displayString = i.translateKey("gui.no_jce.button.upgrade");
        }
        this.continueButton.drawButton(this.mc, mx, my);
        this.downloadButton.drawButton(this.mc, mx, my);
        this.upgradeButton.drawButton(this.mc, mx, my);
    }
}

