/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;

public abstract class BlockModel<T extends BlockLogic> {
    public static RenderBlocks renderBlocks;
    public final Block<T> block;

    public BlockModel(Block<T> block) {
        this.block = block;
    }

    public abstract boolean render(Tessellator var1, int var2, int var3, int var4);

    public boolean renderNoCulling(Tessellator tessellator, int x, int y, int z) {
        BlockModel.renderBlocks.renderAllFaces = true;
        boolean result = this.render(tessellator, x, y, z);
        BlockModel.renderBlocks.renderAllFaces = false;
        return result;
    }

    public boolean renderWithOverrideTexture(Tessellator tessellator, int x, int y, int z, IconCoordinate textureIndex) {
        BlockModel.renderBlocks.overrideBlockTexture = textureIndex;
        boolean result = this.render(tessellator, x, y, z);
        BlockModel.renderBlocks.overrideBlockTexture = null;
        return result;
    }

    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, @Nullable Integer lightmapCoordinate) {
        this.renderBlockOnInventory(tessellator, metadata, brightness, 1.0f, lightmapCoordinate);
    }

    public abstract void renderBlockOnInventory(Tessellator var1, int var2, float var3, float var4, @Nullable Integer var5);

    public abstract boolean shouldItemRender3d();

    public abstract float getItemRenderScale();

    public int renderLayer() {
        return 0;
    }

    public abstract IconCoordinate getBlockTexture(WorldSource var1, int var2, int var3, int var4, Side var5);

    public abstract IconCoordinate getBlockOverbrightTexture(WorldSource var1, int var2, int var3, int var4, int var5);

    public abstract IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side var1, int var2);

    public abstract IconCoordinate getBlockTextureFromSideAndMetadata(Side var1, int var2);

    public abstract IconCoordinate getParticleTexture(Side var1, int var2);

    public abstract boolean shouldSideBeRendered(WorldSource var1, AABB var2, int var3, int var4, int var5, int var6, int var7);

    public abstract boolean shouldSideBeRendered(WorldSource var1, AABB var2, int var3, int var4, int var5, int var6);

    public abstract boolean shouldSideBeColored(WorldSource var1, int var2, int var3, int var4, int var5, int var6);

    public AABB getBlockBoundsForItemRender() {
        return this.block.getBounds();
    }

    public boolean hasOverbright() {
        return false;
    }

    public boolean isRetro() {
        return Minecraft.getMinecraft().currentWorld != null && Minecraft.getMinecraft().currentWorld.isRetro();
    }

    public static void setRenderBlocks(RenderBlocks rb) {
        renderBlocks = rb;
    }

    public void resetRenderBlocks() {
        BlockModel.renderBlocks.renderAllFaces = false;
        BlockModel.renderBlocks.enableAO = false;
        BlockModel.renderBlocks.useInventoryTint = true;
        BlockModel.renderBlocks.flipTexture = false;
        BlockModel.renderBlocks.overrideBlockTexture = null;
        BlockModel.renderBlocks.uvRotateEast = 0;
        BlockModel.renderBlocks.uvRotateWest = 0;
        BlockModel.renderBlocks.uvRotateSouth = 0;
        BlockModel.renderBlocks.uvRotateNorth = 0;
        BlockModel.renderBlocks.uvRotateTop = 0;
        BlockModel.renderBlocks.uvRotateBottom = 0;
        BlockModel.renderBlocks.field_22352_G = 1;
        BlockModel.renderBlocks.renderBitMask = 0;
    }

    public void setRenderSide(Side side, boolean shouldRender) {
        BlockModel.renderBlocks.renderBitMask = !shouldRender ? (byte)(BlockModel.renderBlocks.renderBitMask | (byte)(1 << side.getId())) : (byte)(BlockModel.renderBlocks.renderBitMask & (byte)(~(1 << side.getId())));
    }

    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        return renderBlocks.getBlockBrightness(blockAccess, x, y, z);
    }

    public final boolean renderStandardBlock(Tessellator tessellator, AABB bounds, int x, int y, int z) {
        return renderBlocks.renderStandardBlock(tessellator, this, bounds, x, y, z);
    }

    public final boolean renderStandardBlock(Tessellator tessellator, AABB bounds, int x, int y, int z, float r, float g, float b) {
        return renderBlocks.renderStandardBlock(tessellator, this, bounds, x, y, z, r, g, b);
    }

    public final boolean renderSide(Tessellator tessellator, AABB bounds, int x, int y, int z, Side side, int meta) {
        return renderBlocks.renderSide(tessellator, this, bounds, x, y, z, 1.0f, 1.0f, 1.0f, side, meta);
    }

    public final boolean renderSide(Tessellator tessellator, AABB bounds, int x, int y, int z, float r, float g, float b, Side side, int meta) {
        return renderBlocks.renderSide(tessellator, this, bounds, x, y, z, r, g, b, side, meta);
    }

    public final boolean renderSide(Tessellator tessellator, AABB bounds, int x, int y, int z, float r, float g, float b, int side, int meta, int dirX, int dirY, int dirZ, float depth, int topX, int topY, int topZ, float topP, float botP, int lefX, int lefY, int lefZ, float lefP, float rigP) {
        return renderBlocks.renderSide(tessellator, this, bounds, x, y, z, r, g, b, side, meta, dirX, dirY, dirZ, depth, topX, topY, topZ, topP, botP, lefX, lefY, lefZ, lefP, rigP);
    }

    public final void renderBottomFace(Tessellator tessellator, AABB bounds, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderBottomFace(tessellator, bounds, x, y, z, tex);
    }

    public final void renderTopFace(Tessellator tessellator, AABB bounds, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderTopFace(tessellator, bounds, x, y, z, tex);
    }

    public final void renderNorthFace(Tessellator tessellator, AABB bounds, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderNorthFace(tessellator, bounds, x, y, z, tex);
    }

    public final void renderSouthFace(Tessellator tessellator, AABB bounds, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderSouthFace(tessellator, bounds, x, y, z, tex);
    }

    public final void renderWestFace(Tessellator tessellator, AABB bounds, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderWestFace(tessellator, bounds, x, y, z, tex);
    }

    public final void renderEastFace(Tessellator tessellator, AABB bounds, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderEastFace(tessellator, bounds, x, y, z, tex);
    }
}

