/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import com.b100.utils.StringUtils;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import net.minecraft.client.render.shader.ShaderProvider;
import org.slf4j.Logger;

public class ShaderProviderInternal
implements ShaderProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String dir;

    public ShaderProviderInternal(String dir) {
        this.dir = dir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getShaderSource(String name) {
        String path = this.dir + name;
        try (InputStream stream = ShaderProviderInternal.class.getResourceAsStream(this.dir + name);){
            if (stream != null) {
                String string2 = StringUtils.readInputString(stream);
                return string2;
            }
            LOGGER.error("Resource {} does not exist!", (Object)path);
            String string = null;
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Exception reading shader resource '{}{}'!", this.dir, name, e);
            return null;
        }
    }
}

