/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerSliderElement;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import org.lwjgl.input.Keyboard;

public class EntityEntryMinecart
extends EntityEntry<EntityMinecart> {
    @Override
    public void onTick(EntityMinecart entity) {
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, EntityMinecart minecart) {
        final ListenerButtonElement button = new ListenerButtonElement(-1, -120, 0, 120, 20, I18n.getInstance().translateKey("model.category.entity.minecart.button.cycle"));
        button.setActionListener(() -> minecart.setType((byte)((minecart.getType() + 3 + (Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) ? -1 : 1)) % 3)));
        final ListenerSliderElement slider = new ListenerSliderElement(-1, -120, 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.sheep.slider.color", "White"), 0.0f);
        slider.setOnValueChanged(() -> {
            int sliderVal = (int)(slider.sliderValue * 16.0) - 1;
            if (sliderVal >= 0) {
                DyeColor dc = DyeColor.colorFromBlockMeta(sliderVal);
                minecart.setMeta(dc.blockMeta << 4 | 1);
                String color = dc.colorID;
                String c = String.valueOf(color.charAt(0));
                color = c.toUpperCase() + color.substring(1);
                slider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.minecart.slider.color", color);
            } else {
                minecart.setMeta(0);
                slider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.minecart.slider.color", "none");
            }
        });
        return new ArrayList<ButtonElement>(){
            {
                this.add(button);
                this.add(slider);
            }
        };
    }

    @Override
    public EntityMinecart getEntityInstance(Minecraft mc, World world) {
        EntityMinecart minecart = new EntityMinecart(world);
        minecart.yRot = 270.0f;
        return minecart;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

