/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.data;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import net.betterthanadventure.utils.DataDumper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.enums.EnumGPUVendor;
import net.minecraft.client.gui.ScreenControllerSetup;
import net.minecraft.client.gui.ScreenHudDesigner;
import net.minecraft.client.gui.ScreenSoundTest;
import net.minecraft.client.gui.ScreenTextureViewer;
import net.minecraft.client.gui.achievements.ScreenAchievements;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.options.components.AvailableTexturePackListComponent;
import net.minecraft.client.gui.options.components.BooleanOptionComponent;
import net.minecraft.client.gui.options.components.DifficultyOptionComponent;
import net.minecraft.client.gui.options.components.FloatOptionComponent;
import net.minecraft.client.gui.options.components.FramerateOptionComponent;
import net.minecraft.client.gui.options.components.IntegerOptionComponent;
import net.minecraft.client.gui.options.components.KeyBindingComponent;
import net.minecraft.client.gui.options.components.LanguagePackListComponent;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.SearchFieldComponent;
import net.minecraft.client.gui.options.components.SelectedTexturePackListComponent;
import net.minecraft.client.gui.options.components.ShortcutComponent;
import net.minecraft.client.gui.options.components.ToggleableOptionComponent;
import net.minecraft.client.gui.options.components.TooltipPickerComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPageRegistry;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.option.enums.TooltipStyle;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.util.helper.FileOpener;
import net.minecraft.client.util.helper.JavaProcess;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.Global;
import net.minecraft.core.UnexpectedThrowable;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.enums.ChatVisibility;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import org.useless.seedviewer.SeedViewerMain;
import paulscode.sound.SoundSystem;

public abstract class OptionsPages {
    private static final Minecraft mc = Minecraft.getMinecraft();
    private static boolean hasInit = false;
    public static OptionsPage GENERAL;
    public static OptionsPage AUDIO;
    public static OptionsPage VIDEO;
    public static OptionsPage CONTROLS;
    public static OptionsPage ACCESSIBILITY;
    public static OptionsPage TEXTURE_PACKS;
    public static OptionsPage LANGUAGE;
    public static OptionsPage SEARCH;
    public static OptionsPage DEBUG;

    public static OptionsPage register(OptionsPage page) {
        OptionsPageRegistry.getInstance().register(page);
        return page;
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        GENERAL = OptionsPages.register(new OptionsPage("gui.options.page.general.title", new ItemStack(Blocks.GRASS_RETRO)).withComponent(new OptionsCategory("gui.options.page.general.category.gameplay").withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.FoV)).withComponent(new DifficultyOptionComponent(OptionsPages.mc.gameSettings.difficulty)).withComponent(new ToggleableOptionComponent<PlacementMode>(OptionsPages.mc.gameSettings.placementMode)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.autoHit)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.easyBridge)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.viewBobbing))).withComponent(new OptionsCategory("gui.options.page.general.category.user_interface").withComponent(new ShortcutComponent("gui.options.page.general.button.edit_hud", () -> mc.displayScreen(new ScreenHudDesigner(OptionsPages.mc.currentScreen)))).withComponent(new IntegerOptionComponent(OptionsPages.mc.gameSettings.guiScale)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.screenPadding)).withComponent(new TooltipPickerComponent<TooltipStyle>(OptionsPages.mc.gameSettings.tooltipStyle)).withComponent(new ToggleableOptionComponent<ChatVisibility>(OptionsPages.mc.gameSettings.chatVisibility)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.fpsInOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.versionInOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.foodHealthRegenOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.armorDurabilityOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.heldItemCountOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.heldItemTooltips)).withComponent(new ToggleableOptionComponent(OptionsPages.mc.gameSettings.itemDescriptions)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.hideUndiscoveredItems))).withComponent(new OptionsCategory("gui.options.page.general.category.miscellaneous").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.discordRichPresence)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.enableItemClumping)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.forceUnicodeFont)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.autosaveTimer))).withComponent(new ShortcutComponent("gui.options.page.general.button.open_worlds_folder", () -> FileOpener.open(new File(mc.getMinecraftDir(), "saves")))).withComponent(new ShortcutComponent("gui.options.page.general.button.open_screenshots_folder", () -> {
            File f = new File(mc.getMinecraftDir(), "screenshots");
            f.mkdirs();
            FileOpener.open(f);
        })));
        AUDIO = OptionsPages.register(new OptionsPage("gui.options.page.audio.title", new ItemStack(Items.RECORD_CAT)).withComponent(new OptionsCategory("gui.options.page.audio.category.audio").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.subtitles)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.muteOnLostFocus)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.masterVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.musicVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.worldSoundsVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.weatherSoundsVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.entitySoundsVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.caveSoundsVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.guiSoundsVolume))));
        ToggleableOptionComponent<LightmapStyle> lightmapComponent = new ToggleableOptionComponent<LightmapStyle>(OptionsPages.mc.gameSettings.lightmapStyle);
        VIDEO = OptionsPages.register(new OptionsPage("gui.options.page.video.title", new ItemStack(Items.FLAG)).withComponent(new OptionsCategory("gui.options.page.video.category.graphics").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.fullscreen)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.borderlessFullscreen)).withComponent(new ToggleableOptionComponent<RenderScale>(OptionsPages.mc.gameSettings.renderScale)).withComponent(new ToggleableOptionComponent<Integer>(OptionsPages.mc.gameSettings.fancyGraphics)).withComponent(new ToggleableOptionComponent<Integer>(OptionsPages.mc.gameSettings.renderDistance)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.ambientOcclusion)).withComponent(new ToggleableOptionComponent<Integer>(OptionsPages.mc.gameSettings.mipmapLevels)).withComponent(new ToggleableOptionComponent<MipmapType>(OptionsPages.mc.gameSettings.mipmapType)).withComponent(new ToggleableOptionComponent<Colorblindness>(OptionsPages.mc.gameSettings.colorblindnessFix))).withComponent(new OptionsCategory("gui.options.page.video.category.performance").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.enableVsync)).withComponent(new FramerateOptionComponent(OptionsPages.mc.gameSettings.customFpsLimit)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.advancedOpenGL))).withComponent(new OptionsCategory("gui.options.page.video.category.post_processing").withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.gamma)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.colorCorrection)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.fxaa)).withComponent(new ToggleableOptionComponent<Integer>(OptionsPages.mc.gameSettings.bloom)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.heatHaze))).withComponent(new OptionsCategory("gui.options.page.video.category.visuals").withComponent(Minecraft.GPU_VENDOR == EnumGPUVendor.INTEL ? null : lightmapComponent).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.brightness){

            @Override
            public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
                this.slider.enabled = 1.mc.gameSettings.lightmapStyle.value != LightmapStyle.DISABLED;
                super.render(x, y, width, relativeMouseX, relativeMouseY);
            }
        }).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.fovModification)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.screenMotionEffects)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.fog)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.biomeWater)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.treeShadows)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.vignette)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.items3D)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.clouds)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.cloudHeight)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.aurora)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.slimeParticles)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.blockOutlineWidth))));
        CONTROLS = OptionsPages.register(new OptionsPage("gui.options.page.controls.title", new ItemStack(Items.BOAT)).withComponent(new OptionsCategory("gui.options.page.controls.category.mouse").withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.mouseSensitivity)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.invertMouse)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.rawMouseInput)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.enableItemDragging)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.smoothCamera)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.flightSmoothness)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.turnWithVehicle))).withComponent(new OptionsCategory("gui.options.page.controls.category.keyboard").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.sneakToggle)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.swapCraftingButtons))).withComponent(new OptionsCategory("gui.options.page.controls.category.controller").withComponent(new ShortcutComponent("gui.options.page.controls.button.controller_setup", () -> mc.displayScreen(new ScreenControllerSetup(OptionsPages.mc.currentScreen)))).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.controllerSensitivity)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.controllerMenuSensitivity)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.controllerDeadzoneLeft)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.controllerDeadzoneRight)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.controllerSwapShoulderButtons)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.controllerSwapAB)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.controllerSwapXY))).withComponent(new OptionsCategory("gui.options.page.controls.category.interactions").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyAttack)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyInteract)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyPickBlock))).withComponent(new OptionsCategory("gui.options.page.controls.category.movement").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyForward)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyBack)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLeft)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyRight)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyJump)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySneak)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyFly)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyAutoWalk)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyEasyBridge)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySprint))).withComponent(new OptionsCategory("gui.options.page.controls.category.user_interface").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyInventory)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyChat)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyCommand)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyGuidebook)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyShowRecipe)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyShowUsage)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyDescription)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyOpenAchievements)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyOpenStatistics)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyPlayerList)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHideGui)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleDebug)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleOverlay)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySortInventory))).withComponent(new OptionsCategory("gui.options.page.controls.category.hotbar").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarLeft)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarRight)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSwitch)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyDrop)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot1)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot2)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot3)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot4)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot5)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot6)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot7)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot8)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot9))).withComponent(new OptionsCategory("gui.options.page.controls.category.view").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLookLeft)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLookRight)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLookUp)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLookDown)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyCenterView)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyZoom)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyCinematicCamera)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySwitchPerspective)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyPhotoMode))).withComponent(new OptionsCategory("gui.options.page.controls.category.miscellaneous").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleFog)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleGamma)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLockRotation)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyScreenshot))));
        ACCESSIBILITY = OptionsPages.register(new OptionsPage("gui.options.page.accessibility.title", new ItemStack(Items.WAND_MONSTER_SPAWNER)).withComponent(new OptionsCategory("gui.options.page.accessibility.category.accessibility").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.subtitles)).withComponent(new IntegerOptionComponent(OptionsPages.mc.gameSettings.guiScale)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.screenPadding)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.viewBobbing)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.fovModification)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.screenMotionEffects)).withComponent(new ToggleableOptionComponent<Colorblindness>(OptionsPages.mc.gameSettings.colorblindnessFix)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.turnWithVehicle))));
        TEXTURE_PACKS = OptionsPages.register(new OptionsPage("gui.options.page.texture_packs.title", new ItemStack(Items.PAINTING)).withComponent(new ShortcutComponent("gui.options.page.texture_packs.button.open_folder", () -> FileOpener.open(new File(mc.getMinecraftDir(), "texturepacks")))).withComponent(new OptionsCategory("gui.options.page.texture_packs.category.textures").withComponent(new ToggleableOptionComponent<Integer>(OptionsPages.mc.gameSettings.animations)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.customAnimations)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.mobVariants)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.customLightmap)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.enableHolidayTextures))).withComponent(new ShortcutComponent("gui.options.page.texture_packs.button.apply", () -> OptionsPages.mc.texturePackList.refreshIfReady())).withComponent(new OptionsCategory("gui.options.page.texture_packs.category.texture_packs.selected").withComponent(new SelectedTexturePackListComponent())).withComponent(new OptionsCategory("gui.options.page.texture_packs.category.texture_packs.available").withComponent(new AvailableTexturePackListComponent())));
        LANGUAGE = OptionsPages.register(new OptionsPage("gui.options.page.language_packs.title", new ItemStack(Items.BOOK)).withComponent(new ShortcutComponent("gui.options.page.language_packs.button.open_folder", () -> FileOpener.open(new File(mc.getMinecraftDir(), "languages")))).withComponent(new OptionsCategory("gui.options.page.language_packs.category.language_packs").withComponent(new LanguagePackListComponent())));
        SEARCH = OptionsPages.register(new OptionsPage("gui.options.page.search.title", new ItemStack(Blocks.GLASS)).withComponent(new SearchFieldComponent()));
        DEBUG = new OptionsPage("gui.options.page.debug.title", Blocks.BEDROCK.getDefaultStack()).withComponent(new OptionsCategory("gui.options.page.debug.category.controls").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleTextureAtlas)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleDebug)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyShowShortcuts)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyReload)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySwitchGamemode)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyDumpTextures)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyFullbright)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLightmaps)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyCollisionBoxes)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyChunkBorders)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyClearChat)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyPauseLostFocus)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleItemInfo)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyReloadChunks)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySmoothLighting)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyReleaseCursor)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLoadChunksQuickly))).withComponent(new OptionsCategory("gui.options.page.debug.category.settings").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.alphaMenu)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.lockCamera)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.showDebugScreen)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.showFrameTimes)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.showChunkBorders)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.showCollisionBoxes)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.showItemDebugInfo)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.disableCrashHandler)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.startInFullscreen)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.disableShaders)).withComponent(Minecraft.GPU_VENDOR == EnumGPUVendor.INTEL ? lightmapComponent : null).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.loadAllSounds)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.allowSoundOverrides)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.downloadSoundfiles)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.enableDevResourceLoading)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.enableMultiDrawRendering))).withComponent(new OptionsCategory("gui.options.page.debug.category.utility").withComponent(new ShortcutComponent("gui.options.page.debug.button.open.model_viewer", () -> {
            OptionsPages.mc.playerController = new PlayerControllerSP(mc);
            mc.changeWorld(new WorldClient(), "Loading Model Viewer");
            mc.displayScreen(new ScreenModelViewer());
        }){

            @Override
            public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
                this.button.enabled = mc.currentWorld == null;
                super.render(x, y, width, relativeMouseX, relativeMouseY);
            }
        }).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.sound_test", () -> mc.displayScreen(new ScreenSoundTest(OptionsPages.mc.currentScreen)))).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.texture_viewer", () -> mc.displayScreen(new ScreenTextureViewer(OptionsPages.mc.currentScreen)))).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.biome_finder", () -> {
            new Thread(() -> {
                try {
                    JavaProcess.exec(SeedViewerMain.class, Collections.emptyList());
                }
                catch (IOException | InterruptedException e) {
                    LogUtils.getLogger().error("", e);
                }
            }).start();
            Global.accessor = mc;
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.datadumper", () -> {
            DataDumper.main(new String[0]);
            FileOpener.open(new File(mc.getMinecraftDir(), "infodump"));
            Global.accessor = mc;
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.achievements", () -> mc.displayScreen(new ScreenAchievements(OptionsPages.mc.currentScreen, OptionsPages.mc.statsCounter))))).withComponent(new OptionsCategory("gui.options.page.debug.category.test").withComponent(new ShortcutComponent("gui.options.page.debug.button.music.skip", () -> {
            SoundSystem soundSystem = SoundEngine.getSoundSystem();
            if (soundSystem != null) {
                soundSystem.stop("BgMusic");
            }
            OptionsPages.mc.sndManager.ticksBeforeMusic = -1;
            OptionsPages.mc.sndManager.tick();
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.cheat", () -> OptionsPages.mc.currentWorld.getLevelData().setCheatsEnabled(true)){

            @Override
            public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
                this.button.enabled = mc.currentWorld != null && !mc.currentWorld.isClientSide;
                super.render(x, y, width, relativeMouseX, relativeMouseY);
            }
        }).withComponent(new ShortcutComponent("gui.options.page.debug.button.wipestats", () -> OptionsPages.mc.statsCounter.wipe("I want to delete all the saved stats"))).withComponent(new ShortcutComponent("gui.options.page.debug.button.unlockedall", () -> {
            for (Stat stat : StatList.getAllStats()) {
                OptionsPages.mc.thePlayer.addStat(stat, OptionsPages.mc.thePlayer.getStat(stat) == 0 ? 1 : 0);
            }
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.crash.soft", () -> {
            throw new RuntimeException("Test Soft Exception");
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.crash.hard", () -> {
            Minecraft.getMinecraft().gameWindow.displayCrashReport(new UnexpectedThrowable("Test Hard Exception", new Error()), -1);
            Minecraft.getMinecraft().hasCrashed = true;
            throw new Error();
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.garbage_collect", System::gc)));
    }
}

