/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.block.entity.TileEntityMeshGold;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererMeshGold
extends TileEntityRenderer<TileEntityMeshGold> {
    public EntityItem renderEntity = new EntityItem(null);
    private Random rand = new Random();

    @Override
    public void doRender(Tessellator tessellator, TileEntityMeshGold tileEntity, double x, double y, double z, float renderPartialTicks) {
        if (tileEntity.filterItem == null) {
            return;
        }
        GL11.glPushMatrix();
        float bobbingOffset = MathHelper.sin(((float)tileEntity.ticksRan + renderPartialTicks) / 10.0f) * 0.1f + 0.1f;
        float f3 = (float)Math.toDegrees(((float)tileEntity.ticksRan + renderPartialTicks) / 20.0f);
        GL11.glTranslatef((float)x + 0.5f, (float)y + bobbingOffset + 0.25f, (float)z + 0.5f);
        this.renderEntity.world = tileEntity.worldObj;
        this.renderEntity.x = this.renderEntity.xo = (double)tileEntity.x + 0.5;
        this.renderEntity.y = this.renderEntity.yo = (double)tileEntity.y + 0.5;
        this.renderEntity.z = this.renderEntity.zo = (double)tileEntity.z + 0.5;
        float lightLevel = Minecraft.getMinecraft().currentWorld.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
        if (Global.accessor.isFullbrightEnabled()) {
            lightLevel = 1.0f;
        }
        BlockModel.setRenderBlocks(EntityRenderDispatcher.instance.itemRenderer.renderBlocksInstance);
        GL11.glEnable(32826);
        GL11.glEnable(3042);
        ItemModelDispatcher.getInstance().getDispatch(tileEntity.filterItem).renderAsItemEntity(Tessellator.instance, this.renderEntity, this.rand, tileEntity.filterItem, 1, f3, lightLevel, renderPartialTicks);
        GL11.glDisable(3042);
        GL11.glDisable(32826);
        GL11.glPopMatrix();
        this.renderEntity.world = null;
    }
}

