/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FallbackRenderer;
import net.minecraft.client.render.Framebuffer;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.Global;
import net.minecraft.core.util.helper.Buffer;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.GL11;

public class ScreenshotHelper {
    public final Minecraft minecraft;
    private final Framebuffer framebuffer = new Framebuffer();
    private final Texture colortex = new Texture();
    private final Texture depthtex = new Texture();
    private int width = 1024;
    private int height = 1024;
    private float fov;
    private float yaw;
    private float pitch;
    private Renderer renderer;
    private int oldWidth;
    private int oldHeight;
    private int immersiveMode;

    public ScreenshotHelper(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void takePanoramaScreenshot() throws Exception {
        try {
            this.setup();
            this.takeScreenshot();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.delete();
        }
    }

    private void takeScreenshot() throws Exception {
        this.minecraft.gameSettings.FoV.value = Float.valueOf(0.6056338f);
        this.minecraft.thePlayer.yRot = 0.0f;
        this.minecraft.thePlayer.xRot = 0.0f;
        this.minecraft.thePlayer.yRotO = this.minecraft.thePlayer.yRot;
        this.minecraft.thePlayer.xRotO = this.minecraft.thePlayer.xRot;
        File screenshotFolder = new File(Global.accessor.getMinecraftDir(), "screenshots");
        long now = System.currentTimeMillis();
        File[] files = new File[4];
        for (int i = 0; i < 4; ++i) {
            this.minecraft.thePlayer.yRotO = this.minecraft.thePlayer.yRot = (float)i * 90.0f;
            this.minecraft.worldRenderer.updateCameraAndRender(0.0f);
            BufferedImage image = Textures.getTextureAsImage(this.colortex.id(), false, 0, true);
            File file = new File(screenshotFolder, now + "-" + i + ".png");
            Textures.saveImage(file, image);
            files[i] = file;
        }
        BufferedImage image = new BufferedImage(this.width * 4, this.height, 1);
        Graphics g = image.getGraphics();
        for (int i = 0; i < files.length; ++i) {
            g.drawImage(ImageIO.read(files[i]), this.width * i, 0, null);
        }
        g.dispose();
        Textures.saveImage(new File(screenshotFolder, now + ".png"), image);
    }

    public void setup() {
        this.framebuffer.generate();
        this.colortex.generate();
        this.depthtex.generate();
        Buffer.checkBufferSize(this.width * this.height * 4);
        Buffer.reset();
        this.framebuffer.bind();
        this.colortex.bind();
        GL11.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, Buffer.buffer);
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        GL11.glTexParameteri(3553, 10242, 10496);
        GL11.glTexParameteri(3553, 10243, 10496);
        ARBFramebufferObject.glFramebufferTexture2D(36160, 36064, 3553, this.colortex.id(), 0);
        this.depthtex.bind();
        GL11.glTexImage2D(3553, 0, 6402, this.width, this.height, 0, 6402, 5121, Buffer.buffer);
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        GL11.glTexParameteri(3553, 10242, 10496);
        GL11.glTexParameteri(3553, 10243, 10496);
        ARBFramebufferObject.glFramebufferTexture2D(36160, 36096, 3553, this.depthtex.id(), 0);
        this.fov = ((Float)this.minecraft.gameSettings.FoV.value).floatValue();
        this.yaw = this.minecraft.thePlayer.yRot;
        this.pitch = this.minecraft.thePlayer.xRot;
        this.renderer = this.minecraft.renderer;
        this.oldWidth = this.minecraft.gameWindow.getWidthPixels();
        this.oldHeight = this.minecraft.gameWindow.getHeightPixels();
        this.immersiveMode = (Integer)this.minecraft.gameSettings.immersiveMode.value;
        this.minecraft.gameSettings.immersiveMode.value = 2;
        this.minecraft.renderer = new FallbackRenderer(this.minecraft);
    }

    public void delete() {
        ARBFramebufferObject.glBindFramebuffer(36160, 0);
        this.framebuffer.delete();
        this.colortex.delete();
        this.depthtex.delete();
        this.minecraft.gameSettings.FoV.value = Float.valueOf(this.fov);
        this.minecraft.thePlayer.yRot = this.yaw;
        this.minecraft.thePlayer.xRot = this.pitch;
        this.minecraft.renderer = this.renderer;
        this.minecraft.gameSettings.immersiveMode.value = this.immersiveMode;
    }
}

