/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IntegerSliderElement;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.OptionEnum;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.lang.I18n;

public class DifficultyOptionComponent
extends ButtonComponent {
    protected final OptionEnum<Difficulty> option;
    protected final IntegerSliderElement slider;

    public DifficultyOptionComponent(OptionEnum<Difficulty> difficultyOption) {
        super("options." + difficultyOption.name);
        this.option = difficultyOption;
        this.option.addCallback(__ -> this.onChanged());
        this.slider = new IntegerSliderElement(0, 0, 0, 150, 20, this.option);
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseClicked(mc, this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void buttonDragged(int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void buttonReleased(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseReleased(this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        this.slider.enabled = this.canSetDifficulty();
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.slider.xPosition = x + relativeButtonX;
        this.slider.yPosition = y + relativeButtonY;
        this.slider.width = buttonWidth;
        this.slider.height = buttonHeight;
        this.slider.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
    }

    @Override
    public void init(Minecraft mc) {
        if (!this.canSetDifficulty()) {
            this.slider.enabled = false;
            this.slider.sliderValue = Difficulty.NORMAL.id();
            this.onChanged();
            return;
        }
        this.slider.enabled = true;
        this.option.set(mc.currentWorld.getDifficulty());
        this.slider.sliderValue = ((Difficulty)((Object)this.option.value)).id();
        this.onChanged();
    }

    @Override
    public void resetValue() {
        if (this.canSetDifficulty()) {
            DifficultyOptionComponent.mc.currentWorld.setDifficulty(Difficulty.NORMAL, false);
        }
    }

    @Override
    public boolean isDefault() {
        boolean canSet = this.canSetDifficulty();
        return !canSet || DifficultyOptionComponent.mc.currentWorld.getDifficulty() == Difficulty.NORMAL;
    }

    protected void onChanged() {
        this.slider.displayString = this.getDisplayString();
    }

    protected String getDisplayString() {
        if (!this.canSetDifficulty()) {
            return I18n.getInstance().translateKey("options.difficulty.locked");
        }
        return this.option.getDisplayStringValue();
    }

    protected boolean canSetDifficulty() {
        return DifficultyOptionComponent.mc.currentWorld != null && !DifficultyOptionComponent.mc.currentWorld.getLevelData().getDifficultyLocked() && !DifficultyOptionComponent.mc.currentWorld.isClientSide;
    }
}

