/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelPlayer;
import net.minecraft.client.render.model.ModelPlayerSlim;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.monster.MobHuman;
import org.lwjgl.opengl.GL11;

public class MobRendererHuman
extends MobRenderer<MobHuman> {
    private final ModelBiped modelBipedMain;
    private final ModelPlayer modelThick;
    private final ModelPlayer modelSlim;

    public MobRendererHuman() {
        super(new ModelPlayer(0.0f), 0.5f);
        this.modelBipedMain = (ModelBiped)this.mainModel;
        this.modelThick = new ModelPlayer(0.0f);
        this.modelSlim = new ModelPlayerSlim(0.0f);
    }

    @Override
    public void render(Tessellator tessellator, MobHuman entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        this.mainModel = entity.slimModel ? this.modelSlim : this.modelThick;
        double yRender = y - (double)entity.heightOffset;
        if (entity.isSneaking()) {
            yRender -= 0.125;
        }
        super.render(tessellator, entity, x, yRender, z, yaw, partialTick);
        GL11.glDisable(3042);
    }

    @Override
    protected void setupScale(MobHuman entity, float partialTick) {
        float scale = 0.9375f;
        GL11.glScalef(scale, scale, scale);
    }

    @Override
    public void loadEntityTexture(MobHuman entity) {
        this.bindDownloadableTexture(entity.skinUrl, entity.getEntityTexture(), PlayerSkinParser.instance);
    }
}

