/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ParticleBlockBreaking
extends Particle {
    private final Block<?> block;
    private final Side side;

    public ParticleBlockBreaking(World world, double x, double y, double z, double xa, double ya, double za, Block<?> block, Side side, int meta) {
        super(world, x, y, z, xa, ya, za);
        this.side = side;
        this.block = block;
        this.tex = ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).getParticleTexture(this.side, meta);
        this.gravity = block != null ? block.blockParticleGravity : 0.0f;
        this.bCol = 0.6f;
        this.gCol = 0.6f;
        this.rCol = 0.6f;
        this.size /= 2.0f;
    }

    public ParticleBlockBreaking init(int x, int y, int z) {
        int meta = this.world.getBlockMetadata(x, y, z);
        BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(this.block);
        if (model.shouldSideBeColored(this.world, x, y, z, this.side.getId(), meta)) {
            int col = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(this.world, x, y, z);
            this.rCol *= (float)(col >> 16 & 0xFF) / 255.0f;
            this.gCol *= (float)(col >> 8 & 0xFF) / 255.0f;
            this.bCol *= (float)(col & 0xFF) / 255.0f;
        }
        return this;
    }

    @Override
    public int getParticleTexture() {
        return 1;
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        if (this.tex == null) {
            return;
        }
        float u0 = (float)this.tex.getSubIconU(this.uo / 4.0f);
        float u2 = (float)this.tex.getSubIconU(0.25f + this.uo / 4.0f);
        float v0 = (float)this.tex.getSubIconV(this.uo / 4.0f);
        float v2 = (float)this.tex.getSubIconV(0.25f + this.uo / 4.0f);
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)partialTick - xOff);
        float y = (float)(this.yo + (this.y - this.yo) * (double)partialTick - yOff);
        float z = (float)(this.zo + (this.z - this.zo) * (double)partialTick - zOff);
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmapCoord(partialTick));
        } else {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(br * this.rCol, br * this.gCol, br * this.bCol);
        t.addVertexWithUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u0, v2);
        t.addVertexWithUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u0, v0);
        t.addVertexWithUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u2, v0);
        t.addVertexWithUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u2, v2);
    }
}

