/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.render.Font;
import org.lwjgl.opengl.GL11;

public class ClickableLabelElement
extends ButtonElement {
    private int textColor;
    private int bgColor;
    private boolean shadow = true;

    public ClickableLabelElement(int id, int xPosition, int yPosition, String s, int textColor, int bgColor) {
        super(id, xPosition, yPosition, s);
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.height = 12;
        this.width = 0;
    }

    public ClickableLabelElement(int id, int xPosition, int yPosition, String s, int textColor) {
        this(id, xPosition, yPosition, s, textColor, 0x7F000000);
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        Font font = mc.font;
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        boolean hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        this.width = font.getStringWidth(this.displayString) + 4;
        this.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, this.enabled ? (hovered ? 2139128000 : this.bgColor) : 0);
        if (this.enabled && (this.shadow || hovered)) {
            font.drawStringWithShadow(this.displayString, this.xPosition + 2, this.yPosition + 2, hovered ? 0xFFFFA0 : this.textColor);
        } else {
            font.drawString(this.displayString, this.xPosition + 2, this.yPosition + 2, 0x7F7F7F);
        }
        this.mouseDragged(mc, mouseX, mouseY);
    }
}

