/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.elements.IListenerElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerTextFieldElement;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundEvent;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.client.util.helper.FileOpener;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import paulscode.sound.SoundSystem;

public class ScreenSoundTest
extends Screen {
    private static final int TOP_SPACING = 24;
    private static final int BUTTON_SPACING = 4;
    protected int top;
    protected int bottom;
    protected int entryIndex = 0;
    @Nullable
    protected SoundEvent currentEntry;
    protected List<SoundEvent> allEntries;
    protected ListenerButtonElement leftEntry;
    protected float volume = 1.0f;
    protected float pitch = 1.0f;
    protected boolean showURL = true;

    public ScreenSoundTest(Screen parent) {
        super(parent);
        this.initRepos();
    }

    public void initRepos() {
        this.allEntries = SoundRepository.SOUNDS.getAllEvents();
        this.currentEntry = this.allEntries.get(0);
        this.entryIndex = 0;
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(this.parentScreen);
        }
        ArrayList _buttons = new ArrayList(this.buttons);
        for (ButtonElement button : _buttons) {
            if (!(button instanceof IListenerElement) || !button.isHovered(mx, my)) continue;
            ((IListenerElement)((Object)button)).onKeyTyped(eventCharacter, eventKey);
        }
    }

    @Override
    public void tick() {
        ArrayList _buttons = new ArrayList(this.buttons);
        for (ButtonElement button : _buttons) {
            if (!(button instanceof ListenerButtonElement)) continue;
            ((ListenerButtonElement)button).tick();
        }
    }

    @Override
    public void init() {
        this.top = 24;
        this.bottom = this.height - 28;
        this.add(new ListenerButtonElement(0, this.width / 2 - 100, this.height - 24, 200, 20, I18n.getInstance().translateKey("gui.sound_test.button.done")).setActionListener(() -> {
            this.removed();
            this.mc.displayScreen(null);
        }));
        this.leftEntry = this.add(new ListenerButtonElement(11, this.width - 48, this.bottom - 48, 20, 20, "<").setActionListener(() -> this.cycleEntry(-1)));
        this.add(new ListenerButtonElement(12, this.width - 24, this.bottom - 48, 20, 20, ">").setActionListener(() -> this.cycleEntry(1)));
        ListenerButtonElement b = this.add(new ListenerButtonElement(20, this.width / 2 - 100, this.bottom - 24, 200, 20, I18n.getInstance().translateKey("gui.sound_test.button.play")).setActionListener(this::playEntry));
        b.playSound = false;
        this.add(new ListenerButtonElement(22, this.width / 2 + 100 + 4, this.bottom - 24, 20, 20, "X").setActionListener(this::stopSound));
        this.add(new ListenerButtonElement(30, 4, this.bottom - 24, 20, 20, "").setActionListener(() -> FileOpener.open(new File(this.mc.getMinecraftDir(), "resources"))).setTextures("minecraft:gui/misc/button_folder", "minecraft:gui/misc/button_folder_highlighted", "minecraft:gui/misc/button_folder"));
        this.add(new ListenerButtonElement(31, 28, this.bottom - 24, 20, 20, "V")).setActionListener(() -> {
            this.showURL = !this.showURL;
        });
        this.add(new ListenerButtonElement(32, 52, this.bottom - 24, 40, 20, I18n.getInstance().translateKey("gui.sound_test.button.reload"))).setActionListener(() -> {
            this.mc.sndManager = new SoundEngine();
            this.mc.sndManager.init(this.mc.gameSettings);
            this.initRepos();
        });
        ListenerTextFieldElement volumeField = new ListenerTextFieldElement(this.parentScreen, this.mc.font, this.width - 4 - 60, this.bottom - 72, 60, 20, String.valueOf(this.volume), "Volume");
        this.add(volumeField).setPrefaceText("Vol: ").setKeyListener(key -> {
            try {
                this.volume = Float.parseFloat(volumeField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).setActionListener(() -> {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL)) {
                volumeField.setText(String.valueOf(1));
                this.volume = 1.0f;
            }
        });
        ListenerTextFieldElement pitchField = new ListenerTextFieldElement(this.parentScreen, this.mc.font, this.width - 4 - 60, this.bottom - 96, 60, 20, String.valueOf(this.pitch), "Pitch");
        this.add(pitchField).setPrefaceText("Pitch: ").setKeyListener(key -> {
            try {
                this.pitch = Float.parseFloat(pitchField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).setActionListener(() -> {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL)) {
                pitchField.setText(String.valueOf(1));
                this.pitch = 1.0f;
            }
        });
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
    }

    @Override
    protected void buttonReleased(ButtonElement button) {
    }

    protected void cycleEntry(int offset) {
        if (this.allEntries.size() <= 0) {
            return;
        }
        int index = (this.entryIndex + offset + this.allEntries.size()) % this.allEntries.size();
        this.currentEntry = this.allEntries.get(index);
        this.entryIndex = index;
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        super.render(mx, my, partialTick);
        this.font.drawCenteredString(I18n.getInstance().translateKey("gui.sound_test.label.title"), this.width / 2, 5, 0xFFFFFF);
        String msg = I18n.getInstance().translateKey("gui.sound_test.label.select_entry");
        this.font.drawString(msg, this.leftEntry.getX() - 4 - this.font.getStringWidth(msg), this.leftEntry.getY() + 6, 0xFFFFFF);
        StringBuilder builder = new StringBuilder();
        builder.append(this.font.wrapFormattedStringToWidth(I18n.getInstance().translateKeyAndFormat("gui.sound_test.label.id", this.currentEntry == null ? null : this.currentEntry.getEventID()), this.width - 10)).append("\n");
        builder.append(this.font.wrapFormattedStringToWidth(I18n.getInstance().translateKeyAndFormat("gui.sound_test.label.subtitle", this.currentEntry == null ? null : this.currentEntry.getSubtitleKey(), this.currentEntry == null ? null : this.currentEntry.getSubtitleTranslated()), this.width - 10)).append("\n");
        String[] lines = builder.toString().split("\n");
        int y = this.top + 30;
        for (String line : lines) {
            this.font.drawString(line, 5, y, 0xBBBBBB);
            y += 10;
        }
    }

    @Override
    public void renderBackground() {
        super.renderBackground();
        if (this.mc.currentWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x202020);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)this.bottom / scale);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, (float)this.width / scale, (float)this.bottom / scale);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, (float)this.width / scale, (float)this.top / scale);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)this.top / scale);
            tessellator.draw();
        } else {
            this.drawRect(0, 0, this.width, this.top, 0x5F000000);
            this.drawRect(0, this.bottom, this.width, this.height, 0x5F000000);
        }
    }

    public void playEntry() {
        if (this.currentEntry == null) {
            return;
        }
        this.mc.sndManager.playSoundWithIdAtPos(this.currentEntry.getRandomEntry(), SoundCategory.ENTITY_SOUNDS, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, "debug");
    }

    public void stopSound() {
        SoundSystem soundSystem = SoundEngine.getSoundSystem();
        if (soundSystem == null) {
            return;
        }
        soundSystem.stop("debug");
    }

    private void overlayBackground(int minX, int maxX, int minY, int maxY) {
        if (this.mc.currentWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(minX, maxY, 0.0, (float)minX / scale, (float)maxY / scale);
            tessellator.addVertexWithUV(maxX, maxY, 0.0, (float)maxX / scale, (float)maxY / scale);
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(maxX, minY, 0.0, (float)maxX / scale, (float)minY / scale);
            tessellator.addVertexWithUV(minX, minY, 0.0, (float)minX / scale, (float)minY / scale);
            tessellator.draw();
        }
    }
}

