/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import org.lwjgl.opengl.GL11;

public class SwitchElement
extends ButtonElement {
    private final String onText;
    private final String offText;
    public IconCoordinate backgroundTexture;
    private boolean on;

    public SwitchElement(int id, int xPosition, int yPosition, boolean on, String onText, String offText) {
        super(id, xPosition, yPosition, "");
        this.on = on;
        this.onText = onText;
        this.offText = offText;
        this.updateText();
    }

    public SwitchElement(int id, int xPosition, int yPosition, int width, int height, boolean on, String onText, String offText) {
        super(id, xPosition, yPosition, width, height, "");
        this.on = on;
        this.onText = onText;
        this.offText = offText;
        this.updateText();
    }

    @Override
    protected void setDefaultTextures() {
        this.backgroundTexture = TextureRegistry.getTexture("minecraft:gui/widgets/switch/switch_background");
        this.defaultTexture = TextureRegistry.getTexture("minecraft:gui/widgets/switch/switch");
        this.hoveredTexture = TextureRegistry.getTexture("minecraft:gui/widgets/switch/switch_highlighted");
        this.disabledTexture = TextureRegistry.getTexture("minecraft:gui/widgets/switch/switch_disabled");
    }

    private void updateText() {
        this.displayString = this.on ? this.onText : this.offText;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        this.on = on;
        this.updateText();
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        int textColor;
        IconCoordinate tex;
        if (!this.visible) {
            return;
        }
        Font font = mc.font;
        boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int state = this.getButtonState(mouseOver);
        int xBar = this.on ? this.width / 3 + 1 : 0;
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        switch (state) {
            case 0: {
                tex = this.disabledTexture;
                break;
            }
            case 2: {
                tex = this.hoveredTexture;
                break;
            }
            default: {
                tex = this.defaultTexture;
            }
        }
        this.drawGuiIcon(this.xPosition, this.yPosition, this.width, this.height, this.backgroundTexture);
        this.drawGuiIcon(this.xPosition + xBar, this.yPosition, this.width * 2 / 3, this.height, tex);
        this.mouseDragged(mc, mouseX, mouseY);
        switch (state) {
            case 0: {
                textColor = 0xA0A0A0;
                break;
            }
            case 1: {
                textColor = 0xE0E0E0;
                break;
            }
            default: {
                textColor = 0xFFFFA0;
            }
        }
        this.drawStringCentered(font, this.displayString, this.xPosition + xBar + this.width / 3, this.yPosition + (this.height - 8) / 2, textColor);
    }
}

