/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.util.helper.ItemDragHandler;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.crafting.LookupFuelFurnace;
import net.minecraft.core.crafting.LookupFuelFurnaceBlast;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryBlastFurnace;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryFurnace;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.menu.MenuCrafting;
import net.minecraft.core.player.inventory.menu.MenuFurnace;
import net.minecraft.core.player.inventory.menu.MenuInventory;
import net.minecraft.core.player.inventory.menu.MenuInventoryCreative;
import net.minecraft.core.player.inventory.menu.MenuTrommel;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotCreative;
import net.minecraft.core.player.inventory.slot.SlotResult;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class ScreenContainerAbstract
extends Screen {
    public int xSize;
    public int ySize;
    public MenuAbstract inventorySlots;
    TooltipElement tooltipElement;
    ItemElement itemElement;
    public ItemDragHandler itemDragHandler;

    public ScreenContainerAbstract(MenuAbstract container) {
        Minecraft mc = Minecraft.getMinecraft();
        this.xSize = 176;
        this.ySize = 166;
        this.inventorySlots = container;
        this.tooltipElement = new TooltipElement(mc);
        this.itemElement = new ItemElement(mc);
        this.itemDragHandler = new ItemDragHandler(mc, this, this.itemElement);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1);

    protected void drawGuiContainerForegroundLayer() {
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(partialTick);
        GL11.glPushMatrix();
        GL11.glTranslatef(centerX, centerY, 0.0f);
        this.drawGuiContainerForegroundLayer();
        Slot slot = null;
        for (int i = 0; i < this.inventorySlots.slots.size(); ++i) {
            Slot slot1 = this.inventorySlots.slots.get(i);
            boolean mouseOver = this.getIsMouseOverSlot(slot1, mx, my);
            if (!this.itemDragHandler.isSlotDragged(slot1)) {
                this.itemElement.render(slot1.getItemStack(), slot1.x, slot1.y, mouseOver, slot1);
            }
            if (!mouseOver) continue;
            slot = slot1;
        }
        ContainerInventory inventoryplayer = this.mc.thePlayer.inventory;
        ItemStack grabbedItem = inventoryplayer.getHeldItemStack();
        if (((Boolean)this.mc.gameSettings.enableItemDragging.value).booleanValue()) {
            this.itemDragHandler.drawScreen(mx, my, partialTick);
            ItemStack grabbedItemOverride = this.itemDragHandler.getHeldItemRenderOverride();
            if (grabbedItemOverride != null) {
                grabbedItem = grabbedItemOverride;
            }
        }
        GL11.glPopMatrix();
        super.render(mx, my, partialTick);
        GL11.glPushMatrix();
        if (grabbedItem != null) {
            GL11.glTranslatef(centerX, centerY, 100.0f);
            this.itemElement.render(grabbedItem, mx - centerX - 8, my - centerY - 8);
        }
        GL11.glPopMatrix();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (inventoryplayer.getHeldItemStack() == null && slot != null && slot.hasItem()) {
            boolean showDescription = DescriptionPromptEnum.showDescription(this.mc);
            String str = this.tooltipElement.getTooltipText(slot.getItemStack(), showDescription, slot);
            if (str.length() > 0) {
                this.tooltipElement.render(str, mx, my, 8, -8);
            }
        }
        GL11.glEnable(2929);
    }

    public boolean getIsMouseOverSlot(Slot slot, int i, int j) {
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        return (i -= k) >= slot.x - 1 && i < slot.x + 16 + 1 && (j -= l) >= slot.y - 1 && j < slot.y + 16 + 1;
    }

    public Slot getSlotAtPosition(int i, int j) {
        for (int k = 0; k < this.inventorySlots.slots.size(); ++k) {
            Slot slot = this.inventorySlots.slots.get(k);
            if (!this.getIsMouseOverSlot(slot, i, j)) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void init() {
        super.init();
        this.mc.thePlayer.craftingInventory = this.inventorySlots;
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        int slotId;
        if (eventKey == Keyboard.KEY_ESCAPE || this.mc.gameSettings.keyInventory.isKeyboardKey(eventKey) || eventKey == Keyboard.KEY_BACK) {
            this.mc.thePlayer.closeScreen();
        }
        if ((slotId = this.getSlotId(mx, my)) >= 0) {
            String query;
            Slot slot;
            if (this.mc.gameSettings.keyShowRecipe.isKeyboardKey(eventKey) && (slot = this.inventorySlots.slots.get(slotId)).hasItem()) {
                query = "r:" + slot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve(query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                if (!((SearchableGuidebookSection)GuidebookSections.CRAFTING).searchPages(GuidebookPageManager.searchQuery).isEmpty()) {
                    ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                } else if (!((SearchableGuidebookSection)GuidebookSections.FURNACE).searchPages(GuidebookPageManager.searchQuery).isEmpty()) {
                    ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.FURNACE), true);
                } else if (!((SearchableGuidebookSection)GuidebookSections.BLAST_FURNACE).searchPages(GuidebookPageManager.searchQuery).isEmpty()) {
                    ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.BLAST_FURNACE), true);
                } else if (!((SearchableGuidebookSection)GuidebookSections.TROMMEL).searchPages(GuidebookPageManager.searchQuery).isEmpty()) {
                    ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.TROMMEL), true);
                }
                this.mc.thePlayer.displayGuidebookScreen();
            }
            if (this.mc.gameSettings.keyShowUsage.isKeyboardKey(eventKey) && (slot = this.inventorySlots.slots.get(slotId)).hasItem()) {
                query = "u:" + slot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve(query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                if (!((SearchableGuidebookSection)GuidebookSections.CRAFTING).searchPages(GuidebookPageManager.searchQuery).isEmpty()) {
                    ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                } else if (!((SearchableGuidebookSection)GuidebookSections.FURNACE).searchPages(GuidebookPageManager.searchQuery).isEmpty()) {
                    ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.FURNACE), true);
                } else if (!((SearchableGuidebookSection)GuidebookSections.BLAST_FURNACE).searchPages(GuidebookPageManager.searchQuery).isEmpty()) {
                    ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.BLAST_FURNACE), true);
                } else if (!((SearchableGuidebookSection)GuidebookSections.TROMMEL).searchPages(GuidebookPageManager.searchQuery).isEmpty()) {
                    ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.TROMMEL), true);
                }
                this.mc.thePlayer.displayGuidebookScreen();
            }
            if (this.mc.gameSettings.keyDrop.isKeyboardKey(eventKey)) {
                boolean ctrl = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
                int amount = 1;
                if (ctrl) {
                    amount = 64;
                }
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.DROP, new int[]{slotId, amount}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keyHotBarSlot1.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, 1}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keyHotBarSlot2.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, 2}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keyHotBarSlot3.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, 3}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keyHotBarSlot4.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, 4}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keyHotBarSlot5.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, 5}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keyHotBarSlot6.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, 6}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keyHotBarSlot7.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, 7}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keyHotBarSlot8.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, 8}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keyHotBarSlot9.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, 9}, this.mc.thePlayer);
            }
            if (this.mc.gameSettings.keySortInventory.isKeyboardKey(eventKey)) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.SORT, new int[]{slotId}, this.mc.thePlayer);
            }
        }
        if (this.mc.currentScreen == this && this.mc.gameSettings.keyGuidebook.isKeyboardKey(eventKey)) {
            this.mc.thePlayer.displayGuidebookScreen();
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        if (((Boolean)this.mc.gameSettings.enableItemDragging.value).booleanValue()) {
            this.itemDragHandler.mouseEvent(mx, my, buttonNum, true);
            return;
        }
        if (buttonNum == 0 || buttonNum == 1 || buttonNum == 2 || buttonNum == 10) {
            this.clickInventory(mx, my, buttonNum);
        }
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        if (buttonNum >= 0 && ((Boolean)this.mc.gameSettings.enableItemDragging.value).booleanValue()) {
            this.itemDragHandler.mouseEvent(mx, my, buttonNum, false);
        }
        super.mouseReleased(mx, my, buttonNum);
    }

    public void clickInventory(int x, int y, int mouseButton) {
        int slotId = this.getSlotId(x, y);
        if (slotId == -1) {
            return;
        }
        if (slotId == -999) {
            InventoryAction action = InventoryAction.DROP_HELD_STACK;
            if (mouseButton == 1) {
                action = InventoryAction.DROP_HELD_SINGLE;
            }
            this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, action, null, this.mc.thePlayer);
            return;
        }
        if (!this.mc.thePlayer.getGamemode().consumeBlocks() && mouseButton == 2) {
            Slot slot = this.inventorySlots.getSlot(slotId);
            if (slot.getItemStack() == null) {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.SORT, new int[]{slotId, 64}, this.mc.thePlayer);
            } else {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.CREATIVE_GRAB, new int[]{slotId, 64}, this.mc.thePlayer);
            }
            return;
        }
        InventoryAction action = InventoryAction.CLICK_LEFT;
        boolean shiftPressed = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT);
        boolean ctrlPressed = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
        boolean altPressed = Keyboard.isKeyDown(Keyboard.KEY_LMENU) || Keyboard.isKeyDown(Keyboard.KEY_RMENU);
        boolean spacePressed = Keyboard.isKeyDown(Keyboard.KEY_SPACE);
        if (mouseButton == 10) {
            shiftPressed = true;
            mouseButton = 0;
        }
        if (this.mc.gameSettings.keySortInventory.isMouseButton(mouseButton)) {
            action = InventoryAction.SORT;
        }
        int target = 0;
        Slot slot = this.inventorySlots.getSlot(slotId);
        ItemStack stackInSlot = slot != null ? slot.getItemStack() : null;
        Item itemInSlot = stackInSlot != null ? stackInSlot.getItem() : null;
        int clickedItemId = stackInSlot != null ? stackInSlot.getItem().id : 0;
        ItemStack grabbedItem = this.mc.thePlayer.inventory.getHeldItemStack();
        if (mouseButton == 1) {
            action = InventoryAction.CLICK_RIGHT;
        }
        if (slot instanceof SlotResult) {
            if (((Boolean)this.mc.gameSettings.swapCraftingButtons.value).booleanValue()) {
                if (shiftPressed && ctrlPressed) {
                    action = InventoryAction.MOVE_SIMILAR;
                } else if (shiftPressed) {
                    action = InventoryAction.MOVE_SINGLE_ITEM;
                } else if (ctrlPressed) {
                    action = InventoryAction.MOVE_STACK;
                }
            } else if (shiftPressed && ctrlPressed) {
                action = InventoryAction.MOVE_SIMILAR;
            } else if (shiftPressed) {
                action = InventoryAction.MOVE_STACK;
            } else if (ctrlPressed) {
                action = InventoryAction.MOVE_SINGLE_ITEM;
            }
        } else if (spacePressed) {
            action = InventoryAction.MOVE_ALL;
        } else if (shiftPressed && ctrlPressed) {
            action = InventoryAction.MOVE_SIMILAR;
        } else if (shiftPressed || altPressed) {
            action = InventoryAction.MOVE_STACK;
        } else if (ctrlPressed) {
            action = InventoryAction.MOVE_SINGLE_ITEM;
        }
        if (slot instanceof SlotCreative) {
            ItemStack heldItem = this.mc.thePlayer.inventory.getHeldItemStack();
            if (heldItem != null) {
                if (heldItem.canStackWith(stackInSlot)) {
                    if (shiftPressed || ctrlPressed) {
                        this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.CREATIVE_GRAB, new int[]{slot.index, heldItem.getMaxStackSize()}, this.mc.thePlayer);
                    } else {
                        this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.CREATIVE_GRAB, new int[]{slot.index, heldItem.stackSize + 1}, this.mc.thePlayer);
                    }
                } else {
                    this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.CREATIVE_GRAB, new int[]{slot.index, 0}, this.mc.thePlayer);
                }
            } else if (shiftPressed || ctrlPressed) {
                int amount = 1;
                if (shiftPressed && stackInSlot != null) {
                    amount = stackInSlot.getMaxStackSize();
                }
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.CREATIVE_MOVE, new int[]{slot.index, amount}, this.mc.thePlayer);
            } else {
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.CREATIVE_GRAB, new int[]{slot.index, 1}, this.mc.thePlayer);
            }
            return;
        }
        if (this.inventorySlots instanceof MenuInventory && itemInSlot instanceof IArmorItem) {
            target = 2;
        }
        if (this.inventorySlots instanceof MenuFurnace) {
            boolean isFuel;
            MenuFurnace furnace = (MenuFurnace)this.inventorySlots;
            boolean isBlastFurnace = furnace.furnace instanceof TileEntityFurnaceBlast;
            boolean isIngredient = false;
            if (isBlastFurnace) {
                RecipeEntryBlastFurnace recipe;
                Iterator<RecipeEntryBlastFurnace> iterator = Registries.RECIPES.getAllBlastFurnaceRecipes().iterator();
                while (iterator.hasNext() && !(isIngredient = (recipe = iterator.next()).matches(stackInSlot))) {
                }
                isFuel = LookupFuelFurnaceBlast.instance.getFuelYield(clickedItemId) > 0;
            } else {
                RecipeEntryFurnace recipe;
                Iterator<RecipeEntryFurnace> iterator = Registries.RECIPES.getAllFurnaceRecipes().iterator();
                while (iterator.hasNext() && !(isIngredient = (recipe = iterator.next()).matches(stackInSlot))) {
                }
                boolean bl = isFuel = LookupFuelFurnace.instance.getFuelYield(clickedItemId) > 0;
            }
            if (isIngredient) {
                target = 1;
            } else if (isFuel) {
                target = 2;
            }
        }
        if (this.inventorySlots instanceof MenuTrommel) {
            target = LookupFuelFurnace.instance.getFuelYield(clickedItemId) > 0 ? 2 : 1;
        }
        if ((this.inventorySlots instanceof MenuCrafting || this.inventorySlots instanceof MenuInventory) && altPressed) {
            target = 1;
        }
        if (this.inventorySlots instanceof MenuInventoryCreative && altPressed) {
            this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.CREATIVE_DELETE, new int[]{slot.index}, this.mc.thePlayer);
            return;
        }
        if (slot != null && slot.allowItemInteraction() && grabbedItem != null && grabbedItem.getItem().hasInventoryInteraction() && mouseButton == 1) {
            this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.INTERACT_GRABBED, new int[]{slot.index}, this.mc.thePlayer);
            return;
        }
        if (slot != null && stackInSlot != null && slot.allowItemInteraction() && stackInSlot.getItem().hasInventoryInteraction() && mouseButton == 1) {
            this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.INTERACT_SLOT, new int[]{slot.index}, this.mc.thePlayer);
            return;
        }
        int[] args = new int[]{slotId, target};
        this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, action, args, this.mc.thePlayer);
    }

    @Override
    public void controllerInput(ControllerInput controller) {
        Slot slot = controller.getSlotAtCursor(this);
        if (slot != null) {
            Slot slot3;
            if (controller.digitalPad.right.pressedThisFrame()) {
                slot3 = null;
                for (Slot slot2 : this.inventorySlots.slots) {
                    if (slot2.x <= slot.x || Math.abs(slot2.y - slot.y) >= 12 || slot3 != null && slot2.x >= slot3.x) continue;
                    slot3 = slot2;
                }
                if (slot3 == null) {
                    for (Slot slot2 : this.inventorySlots.slots) {
                        if (Math.abs(slot2.y - slot.y) >= 12 || slot3 != null && slot2.x >= slot3.x) continue;
                        slot3 = slot2;
                    }
                }
                controller.snapToSlot(this, slot3);
            }
            if (controller.digitalPad.left.pressedThisFrame()) {
                slot3 = null;
                for (Slot slot2 : this.inventorySlots.slots) {
                    if (slot2.x >= slot.x || Math.abs(slot2.y - slot.y) >= 12 || slot3 != null && slot2.x <= slot3.x) continue;
                    slot3 = slot2;
                }
                if (slot3 == null) {
                    for (Slot slot2 : this.inventorySlots.slots) {
                        if (Math.abs(slot2.y - slot.y) >= 12 || slot3 != null && slot2.x <= slot3.x) continue;
                        slot3 = slot2;
                    }
                }
                controller.snapToSlot(this, slot3);
            }
            if (controller.digitalPad.up.pressedThisFrame()) {
                slot3 = null;
                for (Slot slot2 : this.inventorySlots.slots) {
                    if (slot2.y >= slot.y || Math.abs(slot2.x - slot.x) >= 12 || slot3 != null && slot2.y <= slot3.y) continue;
                    slot3 = slot2;
                }
                if (slot3 == null) {
                    for (Slot slot2 : this.inventorySlots.slots) {
                        if (Math.abs(slot2.x - slot.x) >= 12 || slot3 != null && slot2.y <= slot3.y) continue;
                        slot3 = slot2;
                    }
                }
                controller.snapToSlot(this, slot3);
            }
            if (controller.digitalPad.down.pressedThisFrame()) {
                slot3 = null;
                for (Slot slot2 : this.inventorySlots.slots) {
                    if (slot2.y <= slot.y || Math.abs(slot2.x - slot.x) >= 12 || slot3 != null && slot2.y >= slot3.y) continue;
                    slot3 = slot2;
                }
                if (slot3 == null) {
                    for (Slot slot2 : this.inventorySlots.slots) {
                        if (Math.abs(slot2.x - slot.x) >= 12 || slot3 != null && slot2.y >= slot3.y) continue;
                        slot3 = slot2;
                    }
                }
                controller.snapToSlot(this, slot3);
            }
        }
        super.controllerInput(controller);
    }

    private int getSlotId(int x, int y) {
        Slot slot = this.getSlotAtPosition(x, y);
        int x2 = (this.width - this.xSize) / 2;
        int y2 = (this.height - this.ySize) / 2;
        boolean flag = x < x2 || y < y2 || x >= x2 + this.xSize || y >= y2 + this.ySize;
        int slotId = -1;
        if (slot != null) {
            slotId = slot.index;
        }
        if (flag) {
            slotId = -999;
        }
        return slotId;
    }

    @Override
    public void removed() {
        if (this.mc.thePlayer == null) {
            return;
        }
        this.mc.playerController.handleCloseInventory(this.inventorySlots.containerId, this.mc.thePlayer);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.mc.thePlayer.isAlive() || this.mc.thePlayer.removed) {
            this.mc.thePlayer.closeScreen();
        }
    }
}

