/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelVeryRotatable;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;

public class BlockModelActivator<T extends BlockLogic>
extends BlockModelVeryRotatable<T> {
    public final IconCoordinate[] poweredTextures = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/activator/bottom_active"), TextureRegistry.getTexture("minecraft:block/activator/top_active"), TextureRegistry.getTexture("minecraft:block/activator/side_active"), TextureRegistry.getTexture("minecraft:block/activator/front_active"), TextureRegistry.getTexture("minecraft:block/activator/side_active"), TextureRegistry.getTexture("minecraft:block/activator/side_active")};

    public BlockModelActivator(Block<T> block) {
        super(block);
        this.overbrightTextures.set("minecraft:block/activator/bottom_active_overlay", Side.BOTTOM).set("minecraft:block/activator/top_active_overlay", Side.TOP).set("minecraft:block/activator/front_active_overlay", Side.SOUTH).set("minecraft:block/activator/side_active_overlay", Side.WEST, Side.EAST, Side.NORTH);
    }

    @Override
    public boolean hasOverbright() {
        return true;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if ((data & 8) != 0) {
            return this.poweredTextures[this.getRotatedSide(side, data).getId()];
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side side, int data) {
        boolean isPowered;
        boolean bl = isPowered = (data & 8) != 0;
        if (!isPowered) {
            return null;
        }
        return super.getBlockOverbrightTextureFromSideAndMeta(side, data);
    }
}

