/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFence;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelFence<T extends BlockLogicFence>
extends BlockModelStandard<T> {
    public BlockModelFence(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        float f7;
        float f = 0.375f;
        float f1 = 0.625f;
        AABB bounds = AABB.getTemporaryBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        this.renderStandardBlock(tessellator, bounds, x, y, z);
        boolean flag1 = false;
        boolean flag2 = false;
        BlockLogicFence fence = (BlockLogicFence)this.block.getLogic();
        if (fence.canConnectTo(BlockModelFence.renderBlocks.blockAccess, x - 1, y, z) || fence.canConnectTo(BlockModelFence.renderBlocks.blockAccess, x + 1, y, z)) {
            flag1 = true;
        }
        if (fence.canConnectTo(BlockModelFence.renderBlocks.blockAccess, x, y, z - 1) || fence.canConnectTo(BlockModelFence.renderBlocks.blockAccess, x, y, z + 1)) {
            flag2 = true;
        }
        boolean flag3 = fence.canConnectTo(BlockModelFence.renderBlocks.blockAccess, x - 1, y, z);
        boolean flag4 = fence.canConnectTo(BlockModelFence.renderBlocks.blockAccess, x + 1, y, z);
        boolean flag5 = fence.canConnectTo(BlockModelFence.renderBlocks.blockAccess, x, y, z - 1);
        boolean flag6 = fence.canConnectTo(BlockModelFence.renderBlocks.blockAccess, x, y, z + 1);
        if (!flag1 && !flag2) {
            flag1 = true;
        }
        float f8 = 0.4375f;
        float f9 = 0.5625f;
        float f2 = 0.75f;
        float f3 = 0.9375f;
        float f4 = flag3 ? 0.0f : 0.4375f;
        float f5 = flag4 ? 1.0f : 0.5625f;
        float f6 = flag5 ? 0.0f : 0.4375f;
        float f10 = f7 = flag6 ? 1.0f : 0.5625f;
        if (flag1) {
            bounds.set(f4, 0.75, 0.4375, f5, 0.9375, 0.5625);
            this.renderStandardBlock(tessellator, bounds, x, y, z);
        }
        if (flag2) {
            bounds.set(0.4375, 0.75, f6, 0.5625, 0.9375, f7);
            this.renderStandardBlock(tessellator, bounds, x, y, z);
        }
        float f102 = 0.375f;
        float f11 = 0.5625f;
        if (flag1) {
            bounds.set(f4, 0.375, 0.4375, f5, 0.5625, 0.5625);
            this.renderStandardBlock(tessellator, bounds, x, y, z);
        }
        if (flag2) {
            bounds.set(0.4375, 0.375, f6, 0.5625, 0.5625, f7);
            this.renderStandardBlock(tessellator, bounds, x, y, z);
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (BlockModelFence.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f(r * brightness, g * brightness, b * brightness, alpha);
        }
        GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
        for (int cube = 0; cube < 4; ++cube) {
            AABB bounds;
            float radius = 0.125f;
            float f5 = 0.0625f;
            switch (cube) {
                case 0: {
                    bounds = AABB.getTemporaryBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.25);
                    break;
                }
                case 1: {
                    bounds = AABB.getTemporaryBB(0.375, 0.0, 0.75, 0.625, 1.0, 1.0);
                    break;
                }
                case 2: {
                    bounds = AABB.getTemporaryBB(0.4375, 0.8125, -0.125, 0.5625, 0.9375, 1.125);
                    break;
                }
                default: {
                    bounds = AABB.getTemporaryBB(0.4375, 0.3125, -0.125, 0.5625, 0.4375, 1.125);
                }
            }
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
            tessellator.draw();
        }
        GL11.glTranslatef(0.5f, 0.5f, 0.5f);
    }
}

