/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;

public class BlockModelPebbles<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate[] pebbles = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/pebbles/0"), TextureRegistry.getTexture("minecraft:block/pebbles/1"), TextureRegistry.getTexture("minecraft:block/pebbles/2")};

    public BlockModelPebbles(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(LightmapHelper.max(this.block.getLightmapCoord(BlockModelPebbles.renderBlocks.blockAccess, x, y, z), this.block.getLightmapCoord(BlockModelPebbles.renderBlocks.blockAccess, x, y - 1, z)));
        } else {
            brightness = Math.max(this.getBlockBrightness(BlockModelPebbles.renderBlocks.blockAccess, x, y, z), this.getBlockBrightness(BlockModelPebbles.renderBlocks.blockAccess, x, y - 1, z));
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        this.renderTopFace(tessellator, this.block.getBlockBoundsFromState(BlockModelPebbles.renderBlocks.blockAccess, x, y, z), x, y, z, this.getBlockTextureFromSideAndMetadata(Side.TOP, BlockModelPebbles.renderBlocks.blockAccess.getBlockMetadata(x, y, z)));
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.pebbles[MathHelper.clamp(data, 0, 2)];
    }
}

