/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;

public class ModelSquid
extends ModelBase {
    Cube squidBody;
    Cube[] squidTentacles = new Cube[8];

    public ModelSquid() {
        int yOffs = -16;
        this.squidBody = new Cube(0, 0);
        this.squidBody.addBox(-6.0f, -8.0f, -6.0f, 12, 16, 12);
        this.squidBody.y += (float)(24 + yOffs);
        for (int i = 0; i < this.squidTentacles.length; ++i) {
            this.squidTentacles[i] = new Cube(48, 0);
            double angle = (double)i * Math.PI * 2.0 / (double)this.squidTentacles.length;
            float xo = (float)Math.cos(angle) * 5.0f;
            float yo = (float)Math.sin(angle) * 5.0f;
            this.squidTentacles[i].addBox(-1.0f, 0.0f, -1.0f, 2, 18, 2);
            this.squidTentacles[i].x = xo;
            this.squidTentacles[i].z = yo;
            this.squidTentacles[i].y = 31 + yOffs;
            angle = (double)i * Math.PI * -2.0 / (double)this.squidTentacles.length + 1.5707963267948966;
            this.squidTentacles[i].yRot = (float)angle;
        }
    }

    @Override
    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        for (int i = 0; i < this.squidTentacles.length; ++i) {
            this.squidTentacles[i].xRot = limbPitch;
        }
    }

    @Override
    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.squidBody.render(scale);
        for (int i = 0; i < this.squidTentacles.length; ++i) {
            this.squidTentacles[i].render(scale);
        }
    }
}

