/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntry;
import net.minecraft.client.gui.modelviewer.elements.ListSelectorButtonElement;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.DisplayChunk;

public class BlockEntryMobSpawner
extends BlockEntry {
    public BlockEntryMobSpawner() {
        super(Blocks.MOBSPAWNER);
    }

    @Override
    public void onTick(World world, int meta) {
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)DisplayChunk.displayTileEntity;
        spawner.yaw2 = spawner.yaw;
        double xPos = (double)spawner.x + (double)spawner.worldObj.rand.nextFloat();
        double yPos = (double)spawner.y + (double)spawner.worldObj.rand.nextFloat();
        double zPos = (double)spawner.z + (double)spawner.worldObj.rand.nextFloat();
        spawner.worldObj.spawnParticle("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
        spawner.worldObj.spawnParticle("flame", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
        spawner.yaw += (double)(1000.0f / ((float)spawner.delay + 200.0f));
        while (spawner.yaw > 360.0) {
            spawner.yaw -= 360.0;
            spawner.yaw2 -= 360.0;
        }
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, World world, int meta) {
        ArrayList<String> ids = new ArrayList<String>();
        for (NamespaceID id : EntityDispatcher.idToClassMap.keySet()) {
            ids.add(id.toString());
        }
        final ListSelectorButtonElement<String> dispatcherIds = new ListSelectorButtonElement<String>(-1, -120, 0, 120, 20, I18n.getInstance().translateKey("model.category.block.spawner.button.id"), ids, "minecraft:pig"){

            @Override
            public String getNameFromElement(String element) {
                return element;
            }
        };
        dispatcherIds.setOnValueChanged(() -> ((TileEntityMobSpawner)DisplayChunk.displayTileEntity).setMobId((String)dispatcherIds.getCurrentElement()));
        return new ArrayList<ButtonElement>(){
            {
                this.add(dispatcherIds);
            }
        };
    }

    @Override
    public void onClose(World world, int meta) {
    }

    @Override
    public void onOpen(World world, int meta) {
    }
}

