/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.controller;

import com.b100.utils.ReflectUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.input.controller.Button;
import net.minecraft.client.input.controller.ControllerInventoryHandler;
import net.minecraft.client.input.controller.ControllerType;
import net.minecraft.client.input.controller.DigitalPad;
import net.minecraft.client.input.controller.IButtonListener;
import net.minecraft.client.input.controller.IJoystickListener;
import net.minecraft.client.input.controller.Joystick;
import net.minecraft.client.input.glfw.GlfwGamepad;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.Time;

public class ControllerInput {
    public final Minecraft minecraft;
    private final GlfwGamepad controller;
    public Joystick joyLeft;
    public Joystick joyRight;
    public Button buttonA;
    public Button buttonB;
    public Button buttonX;
    public Button buttonY;
    public Button buttonLeftTrigger;
    public Button buttonRightTrigger;
    public Button buttonBack;
    public Button buttonStart;
    public Button buttonLeftShoulder;
    public Button buttonRightShoulder;
    public DigitalPad digitalPad;
    public Button[] buttons;
    public Joystick[] joysticks;
    public double cursorX;
    public double cursorY;
    private final ControllerType type;
    public final ControllerInventoryHandler inventoryHandler = new ControllerInventoryHandler(this);
    private boolean disconnected = false;

    public ControllerInput(Minecraft minecraft, GlfwGamepad controller) {
        this.minecraft = minecraft;
        this.controller = controller;
        this.type = ControllerType.fromController(controller);
        this.setup();
    }

    public String getGUID() {
        return this.controller.getGuid();
    }

    public ControllerType getType() {
        return this.type;
    }

    public void setup() {
        IButtonListener defaultButtonListener = this.controller::isButtonPressed;
        IJoystickListener defaultJoystickListener = this.controller::getAxisValue;
        this.joyLeft = new Joystick(this.translateAxis(this.type, 0), 0, 1, defaultJoystickListener, new Button(this.translateBtn(this.type, 9), 9, defaultButtonListener), this.minecraft.gameSettings.controllerDeadzoneLeft);
        this.joyRight = new Joystick(this.translateAxis(this.type, 2), 2, 3, defaultJoystickListener, new Button(this.translateBtn(this.type, 10), 10, defaultButtonListener), this.minecraft.gameSettings.controllerDeadzoneRight);
        this.buttonBack = new Button(this.translateBtn(this.type, 6), 6, defaultButtonListener);
        this.buttonStart = new Button(this.translateBtn(this.type, 7), 7, defaultButtonListener);
        if (((Boolean)this.minecraft.gameSettings.controllerSwapAB.value).booleanValue()) {
            this.buttonA = new Button(this.translateBtn(this.type, 0), 1, defaultButtonListener);
            this.buttonB = new Button(this.translateBtn(this.type, 1), 0, defaultButtonListener);
        } else {
            this.buttonA = new Button(this.translateBtn(this.type, 0), 0, defaultButtonListener);
            this.buttonB = new Button(this.translateBtn(this.type, 1), 1, defaultButtonListener);
        }
        if (((Boolean)this.minecraft.gameSettings.controllerSwapXY.value).booleanValue()) {
            this.buttonX = new Button(this.translateBtn(this.type, 2), 3, defaultButtonListener);
            this.buttonY = new Button(this.translateBtn(this.type, 3), 2, defaultButtonListener);
        } else {
            this.buttonX = new Button(this.translateBtn(this.type, 2), 2, defaultButtonListener);
            this.buttonY = new Button(this.translateBtn(this.type, 3), 3, defaultButtonListener);
        }
        if (((Boolean)this.minecraft.gameSettings.controllerSwapShoulderButtons.value).booleanValue()) {
            this.buttonLeftShoulder = new Button(this.translateBtn(this.type, 4), 5, defaultButtonListener);
            this.buttonRightShoulder = new Button(this.translateBtn(this.type, 5), 4, defaultButtonListener);
            this.buttonLeftTrigger = new Button(this.translateAxis(this.type, 4), 5, axis -> this.controller.getAxisValue(axis) > 0.5f);
            this.buttonRightTrigger = new Button(this.translateAxis(this.type, 5), 4, axis -> this.controller.getAxisValue(axis) > 0.5f);
        } else {
            this.buttonLeftShoulder = new Button(this.translateBtn(this.type, 4), 4, defaultButtonListener);
            this.buttonRightShoulder = new Button(this.translateBtn(this.type, 5), 5, defaultButtonListener);
            this.buttonLeftTrigger = new Button(this.translateAxis(this.type, 4), 4, axis -> this.controller.getAxisValue(axis) > 0.5f);
            this.buttonRightTrigger = new Button(this.translateAxis(this.type, 5), 5, axis -> this.controller.getAxisValue(axis) > 0.5f);
        }
        this.digitalPad = new DigitalPad(new Button("Digital Up", 11, defaultButtonListener), new Button("Digital Left", 14, defaultButtonListener), new Button("Digital Down", 13, defaultButtonListener), new Button("Digital Right", 12, defaultButtonListener));
        this.buttons = ReflectUtils.getAllObjects(ControllerInput.class, Button.class, this);
        this.joysticks = ReflectUtils.getAllObjects(ControllerInput.class, Joystick.class, this);
    }

    public void moveCursor() {
        double speed = 300.0 * Time.delta * (double)(((Float)this.minecraft.gameSettings.controllerMenuSensitivity.value).floatValue() + 0.5f);
        this.cursorX += (Math.pow(this.joyLeft.getX(), 3.0) + (double)this.joyLeft.getX()) / 2.0 * speed;
        this.cursorY += (Math.pow(this.joyLeft.getY(), 3.0) + (double)this.joyLeft.getY()) / 2.0 * speed;
        this.cursorX = Math.max(this.cursorX, 0.0);
        this.cursorY = Math.max(this.cursorY, 0.0);
        this.cursorX = Math.min(this.cursorX, (double)this.minecraft.resolution.getScaledWidthScreenCoords());
        this.cursorY = Math.min(this.cursorY, (double)this.minecraft.resolution.getScaledHeightScreenCoords());
    }

    public boolean hasAnyInput() {
        return this.controller.hasAnyInput();
    }

    public GlfwGamepad getController() {
        return this.controller;
    }

    public void update() {
        int i;
        if (this.disconnected || !this.controller.isPresent()) {
            this.disconnected = true;
            throw new RuntimeException("Controller Disconnected!");
        }
        for (i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].update();
        }
        for (i = 0; i < this.joysticks.length; ++i) {
            this.joysticks[i].update();
        }
        this.digitalPad.update();
    }

    public Slot getSlotAtCursor(ScreenContainerAbstract screen) {
        return this.getSlotAt((int)this.cursorX, (int)this.cursorY, screen);
    }

    public Slot getSlotAt(int x, int y, ScreenContainerAbstract screen) {
        for (Slot slot : screen.inventorySlots.slots) {
            int mx = (int)this.cursorX;
            int my = (int)this.cursorY;
            int slotX = slot.x + (this.minecraft.resolution.getScaledWidthScreenCoords() - screen.xSize) / 2 - 2;
            int slotY = slot.y + (this.minecraft.resolution.getScaledHeightScreenCoords() - screen.ySize) / 2 - 2;
            if (mx <= slotX || my <= slotY || mx >= slotX + 20 || my >= slotY + 20) continue;
            return slot;
        }
        return null;
    }

    public void snapToSlot(ScreenContainerAbstract screen, int id) {
        this.snapToSlot(screen, screen.inventorySlots.getSlot(id));
    }

    public void snapToSlot(ScreenContainerAbstract screen, Slot slot) {
        if (slot == null) {
            return;
        }
        int slotX = slot.x + (this.minecraft.resolution.getScaledWidthScreenCoords() - screen.xSize) / 2 - 1;
        int slotY = slot.y + (this.minecraft.resolution.getScaledHeightScreenCoords() - screen.ySize) / 2 - 1;
        this.cursorX = slotX + 8;
        this.cursorY = slotY + 8;
    }

    public void cancelButtonPresses() {
        for (Button button : this.buttons) {
            button.cancelButtonPress();
        }
    }

    private String translateAxis(ControllerType controllerType, int axis) {
        switch (axis) {
            case 0: 
            case 1: {
                return "Analog Left";
            }
            case 2: 
            case 3: {
                return "Analog Right";
            }
            case 4: {
                switch (controllerType) {
                    case PS3: 
                    case PS4: 
                    case PS5: {
                        return "L2";
                    }
                    case SWITCH: {
                        return "ZL";
                    }
                }
                return "LT";
            }
            case 5: {
                switch (controllerType) {
                    case PS3: 
                    case PS4: 
                    case PS5: {
                        return "R2";
                    }
                    case SWITCH: {
                        return "ZR";
                    }
                }
                return "RT";
            }
        }
        return "Axis " + axis;
    }

    private String translateBtn(ControllerType controllerType, int button) {
        switch (button) {
            case 0: {
                switch (controllerType) {
                    case PS3: 
                    case PS4: 
                    case PS5: {
                        return "X";
                    }
                    case SWITCH: {
                        return "B";
                    }
                }
                return "A";
            }
            case 1: {
                switch (controllerType) {
                    case PS3: 
                    case PS4: 
                    case PS5: {
                        return "O";
                    }
                    case SWITCH: {
                        return "A";
                    }
                }
                return "B";
            }
            case 2: {
                switch (controllerType) {
                    case PS3: 
                    case PS4: 
                    case PS5: {
                        return "\u25a1";
                    }
                    case SWITCH: {
                        return "Y";
                    }
                }
                return "X";
            }
            case 3: {
                switch (controllerType) {
                    case PS3: 
                    case PS4: 
                    case PS5: {
                        return "\u25b3";
                    }
                    case SWITCH: {
                        return "X";
                    }
                }
                return "Y";
            }
            case 6: {
                switch (controllerType) {
                    case XBOX_ONE: {
                        return "View";
                    }
                    case PS3: {
                        return "Select";
                    }
                    case PS4: 
                    case PS5: {
                        return "Share";
                    }
                    case SWITCH: {
                        return "-";
                    }
                }
                return "Back";
            }
            case 7: {
                switch (controllerType) {
                    case XBOX_ONE: {
                        return "Menu";
                    }
                    case PS4: 
                    case PS5: {
                        return "Options";
                    }
                    case SWITCH: {
                        return "+";
                    }
                }
                return "Start";
            }
            case 4: {
                switch (controllerType) {
                    case PS3: 
                    case PS4: 
                    case PS5: {
                        return "L1";
                    }
                    case SWITCH: {
                        return "L";
                    }
                }
                return "LB";
            }
            case 5: {
                switch (controllerType) {
                    case PS3: 
                    case PS4: 
                    case PS5: {
                        return "R1";
                    }
                    case SWITCH: {
                        return "R";
                    }
                }
                return "RB";
            }
            case 9: {
                return "Left Stick";
            }
            case 10: {
                return "Right Stick";
            }
            case 11: {
                return "Digital Up";
            }
            case 13: {
                return "Digital Down";
            }
            case 14: {
                return "Digital Left";
            }
            case 12: {
                return "Digital Right";
            }
        }
        return "Button " + button;
    }
}

