/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;

public class BlockModelAlgae<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelAlgae(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        AABB bounds = this.block.getBlockBoundsFromState(BlockModelAlgae.renderBlocks.blockAccess, x, y, z);
        float brightness = 1.0f;
        if (!LightmapHelper.isLightmapEnabled()) {
            brightness = this.getBlockBrightness(BlockModelAlgae.renderBlocks.blockAccess, x, y, z);
        } else {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(BlockModelAlgae.renderBlocks.blockAccess, x, y, z));
        }
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(BlockModelAlgae.renderBlocks.blockAccess, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque_F(red * brightness, green * brightness, blue * brightness);
        IconCoordinate tex = this.getBlockTextureFromSideAndMetadata(Side.TOP, BlockModelAlgae.renderBlocks.blockAccess.getBlockMetadata(x, y, z));
        this.renderTopFace(tessellator, bounds, x, (double)y - 0.1125, z, tex);
        this.renderBottomFace(tessellator, bounds, x, (double)y + 0.0125, z, tex);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, int side) {
        if (side == 1) {
            return true;
        }
        return super.shouldSideBeRendered(blockAccess, bounds, x, y, z, side);
    }
}

