/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.input.InputType;
import net.minecraft.client.option.OptionFloat;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class SliderElement
extends ButtonElement {
    public double sliderValue;
    public boolean dragging = false;
    private final OptionFloat option;
    public IconCoordinate backgroundTexture;

    public SliderElement(int id, int xPosition, int yPosition, OptionFloat optionFloat) {
        this(id, xPosition, yPosition, 150, 20, optionFloat);
    }

    public SliderElement(int id, int xPosition, int yPosition, int width, int height, OptionFloat optionFloat) {
        super(id, xPosition, yPosition, width, height, optionFloat.getDisplayStringValue());
        this.option = optionFloat;
        this.sliderValue = ((Float)optionFloat.value).floatValue();
    }

    public SliderElement(int id, int xPosition, int yPosition, int width, int height, String text, float defaultValue) {
        super(id, xPosition, yPosition, width, height, text);
        this.option = null;
        this.sliderValue = defaultValue;
    }

    @Override
    protected void setDefaultTextures() {
        this.backgroundTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider_background");
        this.defaultTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider");
        this.hoveredTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider_highlighted");
        this.disabledTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider_disabled");
    }

    @Override
    public void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        if (this.dragging) {
            double realMouseX = mc.inputType == InputType.CONTROLLER ? mc.controllerInput.cursorX : (double)(Mouse.getX() * mc.resolution.getScaledWidthScreenCoords()) / (double)mc.resolution.getWidthScreenCoords();
            this.sliderValue = MathHelper.clamp((realMouseX - (double)(this.xPosition + 4)) / (double)(this.width - 8), 0.0, 1.0);
            if (this.option != null) {
                this.option.set(Float.valueOf((float)this.sliderValue));
                this.displayString = this.option.getDisplayString();
            }
        }
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        int textColor;
        IconCoordinate tex;
        if (!this.visible) {
            return;
        }
        Font font = mc.font;
        boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int state = this.getButtonState(mouseOver);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        switch (state) {
            case 0: {
                tex = this.disabledTexture;
                break;
            }
            case 2: {
                tex = this.hoveredTexture;
                break;
            }
            default: {
                tex = this.defaultTexture;
            }
        }
        this.drawGuiIcon(this.xPosition, this.yPosition, this.width, this.height, this.backgroundTexture);
        this.drawGuiIcon(this.xPosition + (int)(this.sliderValue * (double)(this.width - 8)), this.yPosition, 8, this.height, tex);
        this.mouseDragged(mc, mouseX, mouseY);
        switch (state) {
            case 0: {
                textColor = 0xA0A0A0;
                break;
            }
            case 1: {
                textColor = 0xE0E0E0;
                break;
            }
            default: {
                textColor = 0xFFFFA0;
            }
        }
        this.drawStringCentered(font, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, textColor);
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        if (super.mouseClicked(mc, mouseX, mouseY)) {
            double realMouseX = mc.inputType == InputType.CONTROLLER ? mc.controllerInput.cursorX : (double)(Mouse.getX() * mc.resolution.getScaledWidthScreenCoords()) / (double)mc.resolution.getWidthScreenCoords();
            this.sliderValue = MathHelper.clamp((realMouseX - (double)(this.xPosition + 4)) / (double)(this.width - 8), 0.0, 1.0);
            if (this.option != null) {
                this.option.set(Float.valueOf((float)this.sliderValue));
                this.displayString = this.option.getDisplayString();
            }
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY) {
        this.dragging = false;
    }
}

