/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.achievements.pages;

import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.achievements.ScreenAchievements;
import net.minecraft.client.gui.achievements.data.AchievementPage;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;

public class AchievementPageNether
extends AchievementPage {
    protected final Minecraft mc = Minecraft.getMinecraft();
    protected final ItemStack icon;
    @NotNull
    protected final String key;

    public AchievementPageNether(String key, ItemStack icon) {
        this.key = key;
        this.icon = icon;
    }

    @Override
    @NotNull
    public String getName() {
        return I18n.getInstance().translateNameKey(this.key);
    }

    @Override
    @NotNull
    public String getDescription() {
        return I18n.getInstance().translateDescKey(this.key);
    }

    @Override
    @NotNull
    public AchievementPage.AchievementEntry onOpenAchievement() {
        return Objects.requireNonNull(this.getEntry(Achievements.ENTER_NETHER));
    }

    @Override
    public IconCoordinate getBackgroundTile(ScreenAchievements screen, int layer, Random random, int tileX, int tileY) {
        random.setSeed(random.nextLong() + (long)this.key.hashCode());
        int bedrockLayer = 35;
        int offsetX = tileX + random.nextInt(3) - random.nextInt(3);
        int offsetY = tileY + random.nextInt(3) - random.nextInt(3);
        int r = random.nextInt(50);
        IconCoordinate texture = AchievementPageNether.getTextureFromBlock(Blocks.COBBLE_NETHERRACK);
        if (offsetY >= 35) {
            texture = AchievementPageNether.getTextureFromBlock(Blocks.BEDROCK);
        } else if (r < 10) {
            texture = AchievementPageNether.getTextureFromBlock(Blocks.ORE_NETHERCOAL_NETHERRACK);
        }
        return texture;
    }

    @Override
    public void postProcessBackground(ScreenAchievements screen, Random random, ScreenAchievements.BGLayer layerCache, int orgX, int orgY) {
        if (layerCache.id == 0) {
            int _x;
            int cave = -1;
            for (_x = -100; _x <= 100; ++_x) {
                if (random.nextInt(20) == 0 && cave <= 0) {
                    cave = 20 + random.nextInt(5) - random.nextInt(5);
                }
                if (cave > 0) {
                    int lastY = 25 + random.nextInt(4) - random.nextInt(4);
                    this.carveCircle(screen, layerCache, _x - orgX, lastY - orgY, 2 + random.nextInt(3));
                }
                --cave;
            }
            cave = -1;
            for (_x = -100; _x <= 100; ++_x) {
                if (random.nextInt(10) == 0 && cave <= 0) {
                    cave = 5 + random.nextInt(5) - random.nextInt(5);
                }
                if (cave > 0) {
                    this.carveCircle(screen, layerCache, _x - orgX, 10 + random.nextInt(2) - random.nextInt(2) - orgY, random.nextInt(3));
                }
                --cave;
            }
        }
    }

    @Override
    @NotNull
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public int backgroundLayers() {
        return 1;
    }

    @Override
    public int backgroundColor() {
        return 0;
    }

    @Override
    public IconCoordinate getAchievementIcon(Achievement achievement) {
        return TextureRegistry.getTexture(achievement.getType().texture);
    }

    @Override
    public int lineColorLocked(boolean isHovered) {
        return 8755;
    }

    @Override
    public int lineColorUnlocked(boolean isHovered) {
        return 0x707070;
    }

    @Override
    public int lineColorCanUnlock(boolean isHovered) {
        return 0xFF0000;
    }

    protected void carveCircle(ScreenAchievements screen, ScreenAchievements.BGLayer layer, int centerX, int centerY, int radius) {
        for (int i = centerX - radius; i <= centerX + radius; ++i) {
            for (int j = centerY - radius; j < centerY + radius; ++j) {
                double diffX = (double)i + 0.5 - (double)centerX;
                double diffY = (double)j + 0.5 - (double)centerY;
                if (!(diffX * diffX + diffY * diffY < (double)(radius * radius))) continue;
                layer.put(null, i, j);
            }
        }
    }
}

