/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.Nullable;

public class BlockModelVeryRotatable<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelVeryRotatable(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        int meta = BlockModelVeryRotatable.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        Direction dir = BlockLogicVeryRotatable.metaToDirection(meta);
        if (dir == Direction.DOWN || dir == Direction.UP) {
            BlockModelVeryRotatable.renderBlocks.uvRotateSouth = 1;
            BlockModelVeryRotatable.renderBlocks.uvRotateNorth = 2;
        }
        boolean result = super.render(tessellator, x, y, z);
        this.resetRenderBlocks();
        return result;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderBlockOnInventory(tessellator, 3, brightness, alpha, lightmapCoordinate);
    }

    @Override
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side side, int data) {
        return super.getBlockOverbrightTextureFromSideAndMeta(this.getRotatedSide(side, data), data);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return super.getBlockTextureFromSideAndMetadata(this.getRotatedSide(side, data), data);
    }

    public Side getRotatedSide(Side side, int data) {
        Direction dir = BlockLogicVeryRotatable.metaToDirection(data);
        switch (dir) {
            case SOUTH: {
                return side;
            }
            case EAST: {
                return side.getDirection().rotate(1).getSide();
            }
            case NORTH: {
                return side.getDirection().rotate(2).getSide();
            }
            case WEST: {
                return side.getDirection().rotate(3).getSide();
            }
            case UP: {
                switch (side) {
                    case NORTH: {
                        return Side.TOP;
                    }
                    case SOUTH: {
                        return Side.BOTTOM;
                    }
                    case TOP: {
                        return Side.SOUTH;
                    }
                    case BOTTOM: {
                        return Side.NORTH;
                    }
                }
                return side;
            }
            case DOWN: {
                switch (side) {
                    case NORTH: {
                        return Side.TOP;
                    }
                    case SOUTH: {
                        return Side.BOTTOM;
                    }
                    case TOP: {
                        return Side.NORTH;
                    }
                    case BOTTOM: {
                        return Side.SOUTH;
                    }
                }
                return side;
            }
        }
        return Side.BOTTOM;
    }
}

