/*
 * Decompiled with CFR 0.152.
 */
package b100.installer;

import b100.installer.installer.ProgressListener;
import b100.json.JsonParser;
import b100.json.element.JsonObject;
import b100.utils.FileUtils;
import b100.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class Download {
    public final String url;
    private boolean printProgress = true;
    private ProgressListener progressListener;

    public Download(String url) {
        this.url = url;
    }

    public Download setPrintProgress(boolean printProgress) {
        this.printProgress = printProgress;
        return this;
    }

    public Download setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public String downloadAsString() {
        final StringBuilder str = new StringBuilder();
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                str.append((char)b);
            }
        };
        this.download(out);
        return str.toString();
    }

    public JsonObject downloadAsJson() {
        return JsonParser.instance.parseString(this.downloadAsString());
    }

    public void downloadIntoFile(File file) {
        FileUtils.createFolderForFile(file);
        try {
            this.download(new FileOutputStream(file));
        }
        catch (Exception e) {
            throw new RuntimeException("Downloading file: '" + file.getAbsolutePath() + "' from '" + this.url + "'!", e);
        }
    }

    public BufferedImage getAsImage() {
        File temp = new File("TEMP-" + System.currentTimeMillis() % 1000L + ".png");
        File parent = temp.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        this.downloadIntoFile(temp);
        BufferedImage image = ImageUtils.loadExternalImage(temp);
        temp.delete();
        return image;
    }

    private void download(OutputStream out) {
        HttpURLConnection connection = null;
        BufferedInputStream bin = null;
        FilterOutputStream bout = null;
        try {
            try {
                int read;
                connection = (HttpURLConnection)new URL(this.url).openConnection();
                System.out.println("Downloading: " + connection.getURL());
                long completeFileSize = connection.getContentLengthLong();
                long downloadedFileSize = 0L;
                long lastPrint = 0L;
                bin = new BufferedInputStream(connection.getInputStream());
                bout = new BufferedOutputStream(out);
                byte[] cache = new byte[4096];
                while ((read = bin.read(cache, 0, cache.length)) != -1) {
                    long now;
                    ((BufferedOutputStream)bout).write(cache, 0, read);
                    float progress = (float)((double)(downloadedFileSize += (long)read) / (double)completeFileSize);
                    if (this.progressListener != null) {
                        this.progressListener.setProgress(progress);
                    }
                    if (!this.printProgress || (now = System.currentTimeMillis()) <= lastPrint + 500L) continue;
                    lastPrint = now;
                    int percent = (int)(progress * 100.0f);
                    System.out.println("Downloading: " + percent + "%");
                }
                if (this.printProgress) {
                    System.out.println("Finished Downloading!");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Downloading '" + this.url + "'!", e);
            }
        }
        finally {
            try {
                connection.disconnect();
            }
            catch (Exception exception) {}
            try {
                bin.close();
            }
            catch (Exception exception) {}
            try {
                bout.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }
}

