/*
 * Decompiled with CFR 0.152.
 */
package b100.installer;

import b100.installer.Download;
import b100.installer.Global;
import b100.installer.installer.ProgressListener;
import b100.json.JsonParser;
import b100.json.element.JsonObject;
import b100.utils.FileUtils;
import java.io.File;

public class DownloadHelper {
    private static File localResourcesFolder;

    private static File getLocalResourcesFolder() {
        if (localResourcesFolder == null) {
            localResourcesFolder = new File(Global.getInstallerDirectory(), "resources");
        }
        return localResourcesFolder;
    }

    public static File getFile(String path, ProgressListener progressListener) {
        if (Global.isOffline()) {
            File localFile = new File(DownloadHelper.getLocalResourcesFolder(), path);
            return localFile;
        }
        File downloadsFolder = new File(Global.getInstallerDirectory(), "downloads");
        File cachedFile = new File(downloadsFolder, path);
        if (!cachedFile.exists()) {
            new Download(DownloadHelper.getUrl(path)).setPrintProgress(true).setProgressListener(progressListener).downloadIntoFile(cachedFile);
        }
        return cachedFile;
    }

    public static void downloadFile(String path, File target, ProgressListener progressListener) {
        if (Global.isOffline()) {
            File localFile = new File(DownloadHelper.getLocalResourcesFolder(), path);
            FileUtils.copy(localFile, target);
            return;
        }
        new Download(DownloadHelper.getUrl(path)).setPrintProgress(false).setProgressListener(progressListener).downloadIntoFile(target);
    }

    public static JsonObject getJson(String path) {
        if (Global.isOffline()) {
            File localFile = new File(DownloadHelper.getLocalResourcesFolder(), path);
            return (JsonObject)JsonParser.instance.parseFileContent(localFile);
        }
        return new Download(DownloadHelper.getUrl(path)).setPrintProgress(false).downloadAsJson();
    }

    private static String getUrl(String path) {
        return String.valueOf(Global.getDownloadUrl()) + path.replace(" ", "%20");
    }
}

