/*
 * Decompiled with CFR 0.152.
 */
package b100.installer;

import b100.installer.DownloadHelper;
import b100.installer.gui.classic.VersionListGUI;
import b100.installer.installer.ProgressListener;
import b100.installer.util.ModLoader;
import b100.installer.util.TimeUtil;
import b100.installer.util.Utils;
import b100.json.element.JsonArray;
import b100.json.element.JsonElement;
import b100.json.element.JsonEntry;
import b100.json.element.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class Versions {
    private static final Versions INSTANCE = new Versions();
    private List<Channel> allChannels = new ArrayList<Channel>();
    private List<Version> allVersions = new ArrayList<Version>();
    private Map<String, Version> idToVersionMap = new HashMap<String, Version>();

    public static Versions getInstance() {
        return INSTANCE;
    }

    private Versions() {
        System.out.println("Loading version list...");
        long start = System.currentTimeMillis();
        this.downloadVersionList();
        long end = System.currentTimeMillis();
        long delta = end - start;
        System.out.println("Loading version list took " + delta + "ms");
    }

    private void downloadVersionList() {
        JsonObject channelsObject = DownloadHelper.getJson("bta-client/channels.json");
        JsonArray channels = channelsObject.getArray("channels");
        int index = 0;
        int i = 0;
        while (i < channels.length()) {
            String channelId = channels.get((int)i).getAsString().value;
            Channel channel = new Channel(channelId, null);
            this.allChannels.add(channel);
            JsonObject versionsRoot = DownloadHelper.getJson("bta-client/" + channelId + "/versions-new.json");
            JsonObject versions = versionsRoot.getObject("versions");
            int j = 0;
            while (j < versions.entryList().size()) {
                JsonEntry entry = versions.entryList().get(j);
                JsonObject versionManifest = entry.value.getAsObject();
                String versionId = entry.name;
                String displayName = null;
                if (versionManifest.has("displayName")) {
                    displayName = versionManifest.getString("displayName");
                }
                long releaseTime = 0L;
                JsonElement release = versionManifest.get("release");
                if (release != null) {
                    if (release.isNumber()) {
                        releaseTime = release.getAsNumber().getLong();
                    } else if (release.isString()) {
                        releaseTime = TimeUtil.parseTime(release.getAsString().value);
                    }
                }
                Version version = new Version(versionId, displayName, channel, versionManifest, index++, releaseTime);
                this.allVersions.add(version);
                this.idToVersionMap.put(versionId, version);
                ++j;
            }
            ++i;
        }
        this.allVersions.sort((o1, o2) -> o2.compareTo((Version)o1));
        System.out.println("All Versions: ");
        for (Version version : this.allVersions) {
            System.out.println(version);
        }
    }

    public Version get(String id) {
        return this.idToVersionMap.get(id);
    }

    public List<Version> getAllVersions() {
        return this.allVersions;
    }

    public List<Version> getAllVersions(VersionListGUI.VersionFilter filter, ModLoader loader) {
        if (loader == null) {
            throw new NullPointerException("ModLoader is null!");
        }
        ArrayList<Version> filteredVersions = new ArrayList<Version>();
        for (Version version : this.allVersions) {
            if (!filter.isCompatible(version.id, loader)) continue;
            filteredVersions.add(version);
        }
        return filteredVersions;
    }

    public Version getLatestStableVersion() {
        return this.getLatestVersion(version -> version.channel.id.equals("release"));
    }

    public Version getLatestVersion(Predicate<Version> filter) {
        for (Version version : this.allVersions) {
            if (!filter.test(version)) continue;
            return version;
        }
        throw new RuntimeException("No version found for filter: " + filter);
    }

    public Version getLatestVersion() {
        return this.allVersions.get(0);
    }

    public List<Channel> getAllChannels() {
        return this.allChannels;
    }

    public class Channel {
        public final String id;
        public final String displayName;

        public Channel(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return this.id;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public static class Version
    implements Comparable<Version> {
        public final String id;
        public final String displayName;
        public final Channel channel;
        public final JsonObject manifest;
        public final int index;
        public final long releaseTime;

        public Version(String id, String displayName, Channel channel, JsonObject manifest, int index, long releaseTime) {
            this.id = id;
            this.displayName = displayName;
            this.channel = channel;
            this.manifest = manifest;
            this.index = index;
            this.releaseTime = releaseTime;
        }

        public File getFile(String filename, ProgressListener progressListener) {
            return DownloadHelper.getFile("bta-client/" + this.channel.id + "/" + this.id + "/" + filename, progressListener);
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return this.id;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public static String getDisplayName(Version version) {
            if (version == null) {
                return "Unknown";
            }
            return version.getDisplayName();
        }

        @Override
        public int compareTo(Version o) {
            if (this.releaseTime == o.releaseTime) {
                return o.index - this.index;
            }
            return (int)Utils.clampl(this.releaseTime - o.releaseTime, -1L, 1L);
        }
    }
}

