/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.classic;

import b100.installer.Config;
import b100.installer.Global;
import b100.installer.gui.classic.BetacraftInstallerGUI;
import b100.installer.gui.classic.GridPanel;
import b100.installer.gui.classic.LogGUI;
import b100.installer.gui.classic.MultiMCInstallerGUI;
import b100.installer.gui.classic.VanillaLauncherInstallerGUI;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class InstallerGuiClassic {
    public static InstallerGuiClassic instance;
    public JFrame mainFrame;
    public GridPanel mainPanel;
    public JTabbedPane tabs;
    public VanillaLauncherInstallerGUI vanillaLauncherInstallerGUI;
    public BetacraftInstallerGUI betacraftInstallerGUI;
    public MultiMCInstallerGUI multiMcInstallerGUI;

    public InstallerGuiClassic() {
        if (instance != null) {
            throw new IllegalStateException("Instance already exists!");
        }
        instance = this;
        this.mainFrame = new JFrame("BTA Installer" + (Global.isOffline() ? " (Offline Mode)" : ""));
        this.mainFrame.setMinimumSize(new Dimension(400, 320));
        this.mainPanel = new GridPanel();
        this.vanillaLauncherInstallerGUI = new VanillaLauncherInstallerGUI(this);
        this.betacraftInstallerGUI = new BetacraftInstallerGUI(this);
        this.multiMcInstallerGUI = new MultiMCInstallerGUI(this);
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Vanilla Launcher", this.vanillaLauncherInstallerGUI);
        this.tabs.addTab("BetaCraft", this.betacraftInstallerGUI);
        this.tabs.addTab("MultiMC / Prism Launcher", this.multiMcInstallerGUI);
        this.tabs.addTab("Log", new LogGUI());
        Config config = Config.getInstance();
        String lastInstallType = config.lastInstallType.value;
        if (lastInstallType != null) {
            if (lastInstallType.equalsIgnoreCase("vanilla")) {
                this.tabs.setSelectedIndex(0);
            }
            if (lastInstallType.equalsIgnoreCase("betacraft")) {
                this.tabs.setSelectedIndex(1);
            }
            if (lastInstallType.equalsIgnoreCase("multimc")) {
                this.tabs.setSelectedIndex(2);
            }
        }
        this.mainPanel.add(this.tabs, 0, 1, 1.0, 1.0);
        this.mainFrame.add(this.mainPanel);
        this.mainFrame.pack();
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setLocationRelativeTo(null);
        this.mainFrame.setVisible(true);
    }

    public void showLog() {
        this.tabs.setSelectedIndex(3);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Global.setup(args);
        new InstallerGuiClassic();
    }
}

