/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.classic;

import b100.installer.Config;
import b100.installer.gui.classic.BaseInstallerGUI;
import b100.installer.gui.classic.GuiUtils;
import b100.installer.gui.classic.InstallerGuiClassic;
import b100.installer.gui.classic.VersionComponent;
import b100.installer.installer.ProgressListener;
import b100.installer.installer.VanillaLauncherInstaller;
import b100.installer.util.ModLoader;
import b100.installer.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JTextField;

public class VanillaLauncherInstallerGUI
extends BaseInstallerGUI {
    public static final String INSTALL_TYPE = "vanilla";
    public JTextField minecraftDirectoryTextfield;
    public VanillaLauncherInstaller vanillaLauncherInstaller = new VanillaLauncherInstaller();

    public VanillaLauncherInstallerGUI(InstallerGuiClassic installerGUI) {
        super(installerGUI);
        int inset = 4;
        this.getGridBagConstraints().insets.set(inset, inset, inset, inset);
        this.minecraftDirectoryTextfield = new JTextField();
        this.minecraftDirectoryTextfield.setText(this.getMinecraftDirectory());
        ArrayList<ModLoader> modLoaders = new ArrayList<ModLoader>();
        modLoaders.add(ModLoader.None);
        modLoaders.add(ModLoader.ASMLoader);
        modLoaders.add(ModLoader.Babric);
        this.versionComponent = new VersionComponent(modLoaders, this.vanillaLauncherInstaller);
        this.installButton = new JButton("Install");
        this.installButton.addActionListener(this);
        this.add(GuiUtils.createImagePanel("/logo.png"), 0, 0, 1.0, 1.0);
        this.add(GuiUtils.createTitledPanel(this.minecraftDirectoryTextfield, "Minecraft Directory"), 0, 1, 1.0, 0.0);
        this.add(this.versionComponent, 0, 2, 1.0, 0.0);
        this.add(this.installButton, 0, 3, 1.0, 0.0);
    }

    @Override
    public boolean install() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("version", this.versionComponent.getSelectedVersion().id);
        parameters.put("loader", (Object)this.versionComponent.getSelectedLoader());
        parameters.put("mcdir", this.minecraftDirectoryTextfield.getText());
        return this.vanillaLauncherInstaller.install(parameters, new ProgressListener.Dummy());
    }

    public String getMinecraftDirectory() {
        String last = Config.getInstance().lastMinecraftDirectory.value;
        if (last != null) {
            return last;
        }
        return Utils.getMinecraftDirectory().getAbsolutePath();
    }
}

