/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.classic;

import b100.installer.Config;
import b100.installer.Versions;
import b100.installer.gui.classic.GridPanel;
import b100.installer.gui.classic.VersionListGUI;
import b100.installer.util.ModLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;

public class VersionComponent
extends GridPanel
implements ActionListener {
    public JLabel selectedVersionLabel;
    public JButton selectVersionButton;
    private Versions.Version selectedVersion;
    private ModLoader selectedLoader;
    public List<ModLoader> modLoaders;
    public VersionListGUI.VersionFilter filter;

    public VersionComponent(List<ModLoader> modLoaders, VersionListGUI.VersionFilter filter) {
        this.modLoaders = modLoaders;
        this.filter = filter;
        this.selectedVersionLabel = new JLabel();
        this.selectVersionButton = new JButton("Choose Version");
        this.selectVersionButton.addActionListener(this);
        this.getGridBagConstraints().insets.set(0, 0, 0, 16);
        this.add(this.selectedVersionLabel, 0, 0, 1.0, 0.0);
        this.getGridBagConstraints().insets.set(0, 0, 0, 0);
        this.add(this.selectVersionButton, 1, 0, 0.0, 0.0);
        this.setVersionAndLoader(Config.getInstance().getLastOrNewestVersion(), ModLoader.None);
    }

    public void setVersionAndLoader(Versions.Version version, ModLoader loader) {
        if (version == null) {
            throw new NullPointerException();
        }
        this.selectedVersion = version;
        this.selectedLoader = loader;
        if (this.selectedLoader != ModLoader.None) {
            this.selectedVersionLabel.setText(String.valueOf(this.selectedVersion.getDisplayName()) + " " + this.selectedLoader.getDisplayName());
        } else {
            this.selectedVersionLabel.setText(this.selectedVersion.getDisplayName());
        }
    }

    public Versions.Version getSelectedVersion() {
        return this.selectedVersion;
    }

    public ModLoader getSelectedLoader() {
        return this.selectedLoader;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectVersionButton) {
            new VersionListGUI((version, loader) -> this.setVersionAndLoader(version, loader), this.selectedVersion, this.selectedLoader, this.modLoaders, this.filter);
        }
    }
}

