/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.classic;

import b100.installer.Global;
import b100.installer.Versions;
import b100.installer.gui.classic.ComboBoxData;
import b100.installer.gui.classic.GridPanel;
import b100.installer.util.ModLoader;
import b100.installer.util.Utils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VersionListGUI
implements ActionListener {
    private List<Versions.Version> filteredVersions = new ArrayList<Versions.Version>();
    private List<ListDataListener> dataListeners = new ArrayList<ListDataListener>();
    public JFrame frame;
    public GridPanel mainPanel;
    public JComboBox<ModLoader> modLoaderSelection;
    public JList<String> versionList;
    public Listener listener;
    public JButton refreshButton;
    public JButton confirmButton;
    public JButton cancelButton;
    private Versions.Version selectedVersion;
    private ModLoader selectedLoader;
    public ComboBoxData<ModLoader> modLoaderSelectionData;
    public VersionFilter filter;

    public VersionListGUI(Listener listener, Versions.Version selectedVersion, ModLoader selectedLoader, List<ModLoader> modLoaders, VersionFilter filter) {
        this.listener = listener;
        this.selectedVersion = selectedVersion;
        this.selectedLoader = selectedLoader;
        this.filter = filter;
        this.frame = new JFrame("Select Version");
        this.mainPanel = new GridPanel();
        this.mainPanel.getGridBagConstraints().insets.set(4, 4, 4, 4);
        this.modLoaderSelectionData = new ComboBoxData<ModLoader>(modLoaders);
        this.modLoaderSelection = new JComboBox<ModLoader>(this.modLoaderSelectionData);
        this.modLoaderSelection.setSelectedIndex(Utils.indexOf(this.modLoaderSelectionData.content, selectedLoader));
        this.modLoaderSelection.addActionListener(this);
        this.versionList = new JList<String>(new ListModelImpl());
        this.versionList.setSelectionMode(0);
        this.versionList.setEnabled(false);
        JScrollPane versionListScrollPane = new JScrollPane(this.versionList);
        versionListScrollPane.setPreferredSize(new Dimension(300, 300));
        this.refreshButton = new JButton("Refresh");
        this.confirmButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        GridPanel buttonPanel = new GridPanel();
        buttonPanel.getGridBagConstraints().insets.set(0, 4, 4, 4);
        if (!Global.isOffline()) {
            buttonPanel.add(this.refreshButton, 0, 0, 0.0, 1.0);
        }
        buttonPanel.add(new JPanel(), 1, 0, 1.0, 1.0);
        buttonPanel.add(this.confirmButton, 2, 0, 0.0, 1.0);
        buttonPanel.add(this.cancelButton, 3, 0, 0.0, 1.0);
        this.refreshButton.addActionListener(this);
        this.confirmButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.mainPanel.add(this.modLoaderSelection, 0, 0, 1.0, 0.0);
        this.mainPanel.add(versionListScrollPane, 0, 1, 1.0, 1.0);
        this.mainPanel.add(buttonPanel, 0, 2, 1.0, 0.0);
        this.frame.add(this.mainPanel);
        this.frame.pack();
        this.frame.setDefaultCloseOperation(2);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.setupVersionList();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.modLoaderSelection) {
            this.selectedLoader = (ModLoader)((Object)this.modLoaderSelectionData.content.get(this.modLoaderSelection.getSelectedIndex()));
            this.setupVersionList();
        }
        if (e.getSource() == this.refreshButton) {
            this.refresh();
        }
        if (e.getSource() == this.confirmButton) {
            String selection = this.versionList.getSelectedValue();
            Versions.Version selectedVersion = Versions.getInstance().get(selection);
            if (selectedVersion != null) {
                this.listener.onVersionSelected(selectedVersion, this.selectedLoader);
            }
            this.frame.dispose();
        }
        if (e.getSource() == this.cancelButton) {
            this.frame.dispose();
        }
    }

    public void refresh() {
        this.versionList.setEnabled(false);
        new Thread(() -> {
            long startTime = System.currentTimeMillis();
            long updateTime = System.currentTimeMillis() - startTime;
            long sleepTime = Math.max(0L, 1500L - updateTime);
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setupVersionList();
        }).start();
    }

    public void setupVersionList() {
        this.filteredVersions = Versions.getInstance().getAllVersions(this.filter, this.selectedLoader);
        int i = 0;
        while (i < this.dataListeners.size()) {
            this.dataListeners.get(i).contentsChanged(new ListDataEvent(this, 0, 0, 0));
            ++i;
        }
        this.versionList.validate();
        if (this.selectedVersion != null && (i = Utils.indexOf(this.filteredVersions, this.selectedVersion)) >= 0) {
            this.versionList.setSelectedIndex(i);
        }
        this.versionList.setEnabled(true);
        this.confirmButton.setEnabled(this.filteredVersions.size() > 0);
    }

    class ListModelImpl
    implements ListModel<String> {
        ListModelImpl() {
        }

        @Override
        public int getSize() {
            return VersionListGUI.this.filteredVersions.size();
        }

        @Override
        public String getElementAt(int index) {
            return ((Versions.Version)VersionListGUI.this.filteredVersions.get(index)).getDisplayName();
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            VersionListGUI.this.dataListeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            VersionListGUI.this.dataListeners.remove(l);
        }
    }

    public static interface Listener {
        public void onVersionSelected(Versions.Version var1, ModLoader var2);
    }

    public static interface VersionFilter {
        public boolean isCompatible(String var1, ModLoader var2);
    }
}

