/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.render.Textures;
import b100.installer.gui.modern.screen.GuiScreen;

public class GuiBackground
extends GuiElement {
    public GuiElement parent;
    public int color;
    public int offset = 0;
    private boolean fillsScreen;

    public GuiBackground(GuiElement parent) {
        this(parent, 0x404040);
    }

    public GuiBackground(GuiElement parent, int color) {
        this.parent = parent;
        this.color = color;
        this.fillsScreen = parent instanceof GuiScreen;
    }

    @Override
    public void draw() {
        if (this.parent != null) {
            this.posX = this.parent.posX;
            this.posY = this.parent.posY;
            this.width = this.parent.width;
            this.height = this.parent.height;
        }
        int tileSize = 32;
        int modOffset = this.offset & 0x1F;
        int y0 = this.posY + modOffset;
        int tileX0 = this.posX / 32;
        int tileX1 = (this.posX + this.width - 1) / 32;
        int tileY0 = y0 >> 5;
        int tileY1 = y0 + this.height - 1 >> 5;
        this.renderer.setColor(this.color);
        if (!this.fillsScreen) {
            this.renderer.enableScissor(this.posX, this.posY, this.width, this.height);
        }
        int i = tileX0;
        while (i <= tileX1) {
            int j = tileY0;
            while (j <= tileY1) {
                this.renderer.drawImage(Textures.background, i * 32, j * 32 - modOffset);
                ++j;
            }
            ++i;
        }
        this.renderer.setColor(0xFFFFFF);
        if (!this.fillsScreen) {
            this.renderer.disableScissor();
        }
    }

    public static int ceilDiv(int a, int b) {
        return (int)Math.ceil((double)a / (double)b);
    }
}

