/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.Sound;
import b100.installer.gui.modern.InstallerGuiModern;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.render.Textures;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.util.ActionListener;
import b100.installer.gui.modern.util.FocusListener;
import b100.installer.gui.modern.util.Focusable;
import b100.installer.gui.modern.util.ListenerList;

public class GuiCheckbox
extends GuiElement
implements Focusable {
    public GuiScreen screen;
    public String text;
    private boolean clickable = true;
    private boolean focused = false;
    private boolean checked = false;
    public final ListenerList<ActionListener> actionListeners = new ListenerList(this);
    public final ListenerList<FocusListener> focusListeners = new ListenerList(this);
    private int previousState = 1;

    public GuiCheckbox(GuiScreen screen, String text) {
        this(screen, text, false);
    }

    public GuiCheckbox(GuiScreen screen, String text, boolean checked) {
        this.screen = screen;
        this.text = text;
        this.checked = checked;
        this.width = 100;
        this.height = 20;
    }

    @Override
    public void tick() {
        int newState = this.clickable ? (this.focused || this.screen.isMouseOver(this) ? 2 : 1) : 0;
        if (this.previousState != newState) {
            this.previousState = newState;
            InstallerGuiModern.getInstance().scheduleRepaint();
        }
    }

    @Override
    public void draw() {
        int buttonSize = 20;
        int border = (this.height - buttonSize) / 2;
        int x1 = this.posX + border;
        int y1 = this.posY + border;
        this.renderer.drawSubImage(Textures.button_disabled, x1, y1, 10, this.height, 0, 0);
        this.renderer.drawSubImage(Textures.button_disabled, x1 + 10, y1, 10, this.height, Textures.button_disabled.getWidth() - 10, 0);
        int x2 = x1 + buttonSize / 2;
        int y2 = y1 + buttonSize / 2;
        if (this.checked) {
            int x3 = x2 - Textures.checkmark.getWidth() / 2;
            int y3 = y2 - Textures.checkmark.getHeight() / 2;
            this.renderer.drawImage(Textures.checkmark, x3, y3);
        }
        if (this.text != null) {
            int fontColor = this.previousState == 2 ? 0xFFFF80 : (this.previousState == 1 ? 0xFFFFFF : 0x808080);
            int x4 = this.posX + border + buttonSize + 4;
            int y4 = this.posY + this.height / 2 - 4;
            this.fontRenderer.drawString(this.text, x4, y4, fontColor, true);
        }
    }

    @Override
    public boolean keyEvent(int key, boolean pressed) {
        if (pressed && this.focused && (key == 10 || key == 32)) {
            this.clickButton();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        if (this.clickable && pressed && this.screen.isMouseOver(this)) {
            this.clickButton();
            return true;
        }
        return super.mouseEvent(button, pressed, mouseX, mouseY);
    }

    public void clickButton() {
        this.checked = !this.checked;
        Sound.click.play();
        this.actionListeners.forEach(listener -> listener.actionPerformed(this));
        InstallerGuiModern.getInstance().scheduleRepaint();
    }

    public void setChecked(boolean checked) {
        if (checked != this.checked) {
            this.checked = checked;
            InstallerGuiModern.getInstance().scheduleRepaint();
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused != this.focused) {
            this.focused = focused;
            this.focusListeners.forEach(listener -> listener.focusChanged(this));
        }
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean isFocusable() {
        return this.clickable;
    }

    @Override
    public ListenerList<FocusListener> getFocusListeners() {
        return this.focusListeners;
    }

    public ListenerList<ActionListener> getActionListeners() {
        return this.actionListeners;
    }

    public GuiCheckbox addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
        return this;
    }

    public boolean removeActionListener(ActionListener actionListener) {
        return this.actionListeners.remove(actionListener);
    }
}

