/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.util.ContainerListener;
import b100.installer.gui.modern.util.FocusDirection;
import b100.installer.gui.modern.util.FocusListener;
import b100.installer.gui.modern.util.Focusable;
import b100.installer.gui.modern.util.ListenerList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GuiContainer
extends GuiElement
implements FocusListener {
    private final List<GuiElement> elementsMutable = new ArrayList<GuiElement>();
    public final List<GuiElement> elements = Collections.unmodifiableList(this.elementsMutable);
    public final ListenerList<ContainerListener> containerListeners = new ListenerList(this);
    protected boolean isList = false;
    private Focusable lastFocusedElement = null;

    @Override
    public void tick() {
        int i = 0;
        while (i < this.elements.size()) {
            this.elements.get(i).tick();
            ++i;
        }
    }

    @Override
    public void draw() {
        int i = 0;
        while (i < this.elements.size()) {
            this.elements.get(i).draw();
            ++i;
        }
    }

    @Override
    public boolean keyEvent(int key, boolean pressed) {
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.get(i).keyEvent(key, pressed)) {
                return true;
            }
            ++i;
        }
        return super.keyEvent(key, pressed);
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.get(i).mouseEvent(button, pressed, mouseX, mouseY)) {
                return true;
            }
            ++i;
        }
        return super.mouseEvent(button, pressed, mouseX, mouseY);
    }

    @Override
    public boolean charEvent(char c) {
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.get(i).charEvent(c)) {
                return true;
            }
            ++i;
        }
        return super.charEvent(c);
    }

    @Override
    public boolean scrollEvent(double verticalAmount, double mouseX, double mouseY) {
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.get(i).scrollEvent(verticalAmount, mouseX, mouseY)) {
                return true;
            }
            ++i;
        }
        return super.scrollEvent(verticalAmount, mouseX, mouseY);
    }

    @Override
    public void onResize() {
        int i = 0;
        while (i < this.elements.size()) {
            this.elements.get(i).onResize();
            ++i;
        }
        super.onResize();
    }

    public <E extends GuiElement> E add(E element) {
        if (element == null) {
            throw new NullPointerException("Added element is null!");
        }
        this.elementsMutable.add(element);
        this.onElementAdded(element);
        element.onAddedToContainer(this);
        return element;
    }

    public void onElementAdded(GuiElement element) {
        this.containerListeners.forEach(e -> e.elementAdded(this, element));
    }

    public boolean remove(GuiElement element) {
        if (this.elementsMutable.remove(element)) {
            this.onElementRemoved(element);
            element.onRemovedFromContainer(this);
            return true;
        }
        return false;
    }

    public void onElementRemoved(GuiElement element) {
    }

    public boolean contains(GuiElement element) {
        int i = 0;
        while (i < this.elements.size()) {
            GuiContainer container;
            GuiElement e = this.elements.get(i);
            if (e == element) {
                return true;
            }
            if (e instanceof GuiContainer && (container = (GuiContainer)e).contains(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeAll() {
        for (GuiElement element : new ArrayList<GuiElement>(this.elements)) {
            this.remove(element);
        }
    }

    public GuiElement getClickElementAt(double x, double y) {
        int i = this.elements.size() - 1;
        while (i >= 0) {
            GuiContainer container;
            GuiElement clickElement;
            GuiElement element = this.elements.get(i);
            if (element instanceof GuiContainer && (clickElement = (container = (GuiContainer)element).getClickElementAt(x, y)) != null) {
                return clickElement;
            }
            if (element.isSolid() && element.isInside(x, y)) {
                return element;
            }
            --i;
        }
        return null;
    }

    public Focusable getFirstFocusableElement(FocusDirection direction) {
        int dir;
        int start;
        boolean backwards;
        if (direction.isListNavigation()) {
            backwards = direction.isForwards();
        } else {
            boolean bl = backwards = !direction.isForwards();
        }
        if (!backwards) {
            start = 0;
            dir = 1;
        } else {
            start = this.elements.size() - 1;
            dir = -1;
        }
        return this.getNextFocusable(start, dir, direction);
    }

    public Focusable getNextFocusable(GuiElement element, FocusDirection direction) {
        if (this.isList && direction.isTab()) {
            return null;
        }
        if (direction.isListNavigation()) {
            return this.getFirstFocusableElement(direction);
        }
        int start = this.elements.indexOf(element);
        if (start == -1) {
            return this.getFirstFocusableElement(direction);
        }
        int dir = direction.isForwards() ? 1 : -1;
        return this.getNextFocusable(start + dir, dir, direction);
    }

    protected final Focusable getNextFocusable(int start, int dir, FocusDirection direction) {
        int i = start;
        while (i >= 0 && i < this.elements.size()) {
            GuiContainer container;
            Focusable focusable;
            GuiElement element = this.elements.get(i);
            if (element instanceof GuiContainer && (focusable = (container = (GuiContainer)element).getFirstFocusableElement(direction)) != null) {
                return focusable;
            }
            if (Focusable.isFocusable(element)) {
                return (Focusable)((Object)element);
            }
            i += dir;
        }
        return null;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    public Focusable getLastFocusedElement() {
        if (!this.contains((GuiElement)((Object)this.lastFocusedElement))) {
            this.lastFocusedElement = null;
        }
        return this.lastFocusedElement;
    }

    public boolean setLastFocusedElement(Focusable element) {
        if (this.contains((GuiElement)((Object)element))) {
            this.lastFocusedElement = element;
            return true;
        }
        return false;
    }

    @Override
    public void focusChanged(Focusable focusable) {
        GuiElement element;
        if (focusable.isFocused() && this.contains(element = (GuiElement)((Object)focusable))) {
            this.lastFocusedElement = focusable;
        }
    }

    public boolean isListContainer() {
        return this.isList;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[x=" + this.posX + ",y=" + this.posY + ",w=" + this.width + ",h=" + this.height + ",elements=" + this.elements.size() + "]";
    }
}

