/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.gui.modern.element.GuiContainer;
import b100.installer.gui.modern.render.FontRenderer;
import b100.installer.gui.modern.render.Renderer;

public abstract class GuiElement {
    public Renderer renderer = Renderer.instance;
    public FontRenderer fontRenderer = FontRenderer.instance;
    public int posX;
    public int posY;
    public int width;
    public int height;
    private GuiContainer container;

    public void tick() {
    }

    public abstract void draw();

    public boolean keyEvent(int key, boolean pressed) {
        return false;
    }

    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        return false;
    }

    public boolean charEvent(char c) {
        return false;
    }

    public boolean scrollEvent(double verticalAmount, double mouseX, double mouseY) {
        return false;
    }

    public void onResize() {
    }

    public GuiElement setPosition(int x, int y) {
        this.posX = x;
        this.posY = y;
        return this;
    }

    public GuiElement setSize(int w, int h) {
        this.width = w;
        this.height = h;
        return this;
    }

    public GuiElement setPositionAndSize(GuiElement element) {
        this.posX = element.posX;
        this.posY = element.posY;
        this.width = element.width;
        this.height = element.height;
        return this;
    }

    public boolean isInside(double x, double y) {
        return x >= (double)this.posX && y >= (double)this.posY && x < (double)(this.posX + this.width) && y < (double)(this.posY + this.height);
    }

    public boolean isSolid() {
        return true;
    }

    public void onAddedToContainer(GuiContainer container) {
        if (this.container != null) {
            throw new RuntimeException("Cannot add element " + this + "to container " + container + " because element is already added to container " + this.container + "!");
        }
        this.container = container;
    }

    public void onRemovedFromContainer(GuiContainer container) {
        this.container = null;
    }

    public GuiContainer getContainer() {
        return this.container;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[x=" + this.posX + ",y=" + this.posY + ",w=" + this.width + ",h=" + this.height + "]";
    }
}

