/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.element.GuiScrollableList;
import b100.installer.gui.modern.screen.GuiScreen;

public class GuiScrollBar
extends GuiElement {
    public GuiScreen screen;
    public GuiScrollableList list;
    protected boolean dragging = false;
    protected int dragButton = 0;
    protected double previousScrollAmount;
    protected double clickPosX;
    protected double clickPosY;

    public GuiScrollBar(GuiScreen screen, GuiScrollableList list) {
        this.screen = screen;
        this.list = list;
        this.width = 6;
    }

    @Override
    public void tick() {
        int scrollRegionHeight = this.list.getScrollRegionHeight();
        int contentHeight = this.list.getContentHeight();
        int scrollerHeight = this.getScrollerHeight();
        if (this.dragging) {
            double offset = this.clickPosY - this.screen.mouseY;
            int scrollableAreaLength = this.height - scrollerHeight;
            double d = offset / (double)scrollableAreaLength;
            this.list.setScrollAmount(this.previousScrollAmount - (d *= (double)(contentHeight - scrollRegionHeight)));
        }
    }

    protected int getScrollerHeight() {
        int scrollRegionHeight = this.list.getScrollRegionHeight();
        int contentHeight = this.list.getContentHeight();
        float f = (float)scrollRegionHeight / (float)contentHeight;
        int scrollerHeight = (int)((float)this.height * f);
        scrollerHeight = Math.max(scrollerHeight, 32);
        scrollerHeight = Math.min(scrollerHeight, this.height - this.width);
        return scrollerHeight;
    }

    @Override
    public void draw() {
        if (!this.isSolid()) {
            return;
        }
        int scrollerHeight = this.getScrollerHeight();
        float scrollFactor = (float)(this.list.getScrollAmount() / this.list.getMaxScrollAmount());
        int scrollerOffset = (int)(scrollFactor * (float)(this.height - scrollerHeight));
        this.renderer.setColor(0);
        this.renderer.drawRectangle(this.posX, this.posY, this.width, this.height);
        this.renderer.setColor(0x808080);
        this.renderer.drawRectangle(this.posX, this.posY + scrollerOffset, this.width, scrollerHeight);
        this.renderer.setColor(0xC0C0C0);
        this.renderer.drawRectangle(this.posX, this.posY + scrollerOffset, this.width - 1, scrollerHeight - 1);
        this.renderer.setColor(0xFFFFFF);
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        if (!pressed && this.dragging && button == this.dragButton) {
            this.dragging = false;
        }
        if (pressed && !this.dragging && this.screen.isMouseOver(this)) {
            this.dragging = true;
            this.dragButton = button;
            this.previousScrollAmount = this.list.getScrollAmount();
            this.clickPosX = mouseX;
            this.clickPosY = mouseY;
        }
        return super.mouseEvent(button, pressed, mouseX, mouseY);
    }

    @Override
    public boolean isSolid() {
        return this.list.getContentHeight() > this.list.getScrollRegionHeight();
    }
}

