/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.screen;

import b100.installer.Global;
import b100.installer.gui.modern.element.GuiBackground;
import b100.installer.gui.modern.element.GuiButton;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.render.Textures;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.screen.multimc.GuiChooseMultiMCFolder;
import b100.installer.gui.modern.screen.multimc.GuiInstallMultiMC;
import b100.installer.gui.modern.util.ActionListener;
import b100.installer.util.MultiMCHelper;
import java.io.File;

public class GuiMainMenu
extends GuiScreen
implements ActionListener {
    public GuiButton buttonMultiMc;
    public GuiButton buttonBetaCraft;
    public GuiButton buttonVanillaLauncher;

    public GuiMainMenu(GuiScreen parentScreen) {
        super(parentScreen);
    }

    @Override
    protected void onInit() {
        this.add(new GuiBackground(this));
        this.buttonMultiMc = this.add(new GuiButton(this, "MultiMC / Prism Launcher").addActionListener(this));
        this.buttonBetaCraft = this.add(new GuiButton(this, "Betacraft"));
        this.buttonVanillaLauncher = this.add(new GuiButton(this, "Vanilla Launcher"));
        this.buttonBetaCraft.setClickable(false);
        this.buttonVanillaLauncher.setClickable(false);
    }

    @Override
    public void draw() {
        super.draw();
        int x = (this.renderer.getWidth() - Textures.logo.getWidth()) / 2;
        int y = 30;
        int w = this.fontRenderer.getStringWidth(Global.VERSION);
        this.renderer.drawImage(Textures.logo, x, y + 8);
        this.fontRenderer.drawString("Better than Adventure! Installer", 2, 2, 0x505050, true);
        this.fontRenderer.drawString(Global.VERSION, this.width - w - 1, this.height - 9, 0x505050, true);
    }

    @Override
    public void onResize() {
        int x1 = this.width / 2 - 100;
        int y1 = this.height / 4;
        int p = 24;
        this.buttonMultiMc.setPosition(x1, y1 + p * 3);
        this.buttonBetaCraft.setPosition(x1, y1 + p * 4);
        this.buttonVanillaLauncher.setPosition(x1, y1 + p * 5);
    }

    @Override
    public void actionPerformed(GuiElement source) {
        if (source == this.buttonMultiMc) {
            File launcherFolder = MultiMCHelper.getLauncherDirectory();
            if (launcherFolder != null) {
                this.setScreen(new GuiInstallMultiMC(this, launcherFolder));
            } else {
                this.setScreen(new GuiChooseMultiMCFolder(this));
            }
        }
    }
}

