/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.screen;

import b100.installer.Versions;
import b100.installer.gui.classic.VersionListGUI;
import b100.installer.gui.modern.element.GuiBackground;
import b100.installer.gui.modern.element.GuiButton;
import b100.installer.gui.modern.element.GuiCheckbox;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.element.GuiListButton;
import b100.installer.gui.modern.element.GuiScrollBar;
import b100.installer.gui.modern.element.GuiScrollableList;
import b100.installer.gui.modern.element.GuiTextElement;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.util.ActionListener;
import b100.installer.gui.modern.util.FocusListener;
import b100.installer.gui.modern.util.Focusable;
import b100.installer.util.ModLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class GuiSelectVersion
extends GuiScreen
implements ActionListener,
FocusListener {
    private static Map<Versions.Channel, Boolean> enabledChannels = new HashMap<Versions.Channel, Boolean>();
    public VersionListGUI.VersionFilter versionFilter;
    public Consumer<Versions.Version> consumer;
    public GuiTextElement title;
    public GuiButton selectButton;
    public Versions.Version selectedVersion = null;
    private GuiBackground scrollListBackground;
    public GuiScrollableList scrollList;
    public GuiScrollBar scrollBar;
    public List<ChannelCheckbox> channelCheckboxes;

    public GuiSelectVersion(GuiScreen parentScreen, VersionListGUI.VersionFilter versionFilter, Consumer<Versions.Version> consumer, Versions.Version initialSelection) {
        super(parentScreen);
        this.versionFilter = versionFilter;
        this.consumer = consumer;
        this.selectedVersion = initialSelection;
    }

    @Override
    protected void onInit() {
        this.add(new GuiBackground(this));
        this.title = this.add(new GuiTextElement("Select Version", 0.5, 0.5));
        this.scrollListBackground = this.add(new GuiBackground(null, 0x202020));
        this.scrollList = this.add(new GuiScrollableList(this));
        this.scrollList.createShadows(this);
        this.scrollList.useScissor = true;
        this.scrollBar = this.add(new GuiScrollBar(this, this.scrollList));
        this.selectButton = new GuiButton(this, "Select");
        this.selectButton.addActionListener(this);
        this.channelCheckboxes = new ArrayList<ChannelCheckbox>();
        List<Versions.Channel> channels = Versions.getInstance().getAllChannels();
        for (Versions.Channel channel : channels) {
            if (!enabledChannels.containsKey(channel)) {
                enabledChannels.put(channel, true);
            }
            ChannelCheckbox checkbox = new ChannelCheckbox(this, channel);
            checkbox.setChecked(this.isChannelActive(channel));
            checkbox.addActionListener(this);
            this.add(checkbox);
            this.channelCheckboxes.add(checkbox);
        }
        this.updateVersionList();
        this.add(this.selectButton);
    }

    @Override
    public void draw() {
        this.scrollListBackground.offset = (int)(this.scrollList.getScrollAmount() / 2.0);
        super.draw();
    }

    public void updateVersionList() {
        this.scrollList.removeAll();
        boolean selectedVersionIsVisible = false;
        List<Versions.Version> versions = Versions.getInstance().getAllVersions(this.versionFilter, ModLoader.None);
        int i = 0;
        while (i < versions.size()) {
            Versions.Version version = versions.get(i);
            if (this.isChannelActive(version.channel)) {
                VersionButton button = new VersionButton(this, version);
                button.addFocusListener(this);
                if (version.equals(this.selectedVersion)) {
                    button.setFocused(true);
                    selectedVersionIsVisible = true;
                }
                this.scrollList.add(button);
            }
            ++i;
        }
        this.selectButton.setClickable(selectedVersionIsVisible);
    }

    public boolean isChannelActive(Versions.Channel channel) {
        Boolean enabled = enabledChannels.get(channel);
        return enabled != null && enabled != false;
    }

    @Override
    public void onResize() {
        int headerSize = 32;
        int footerSize = 32;
        int listWidth = this.width - 120;
        int listHeight = this.height - headerSize - footerSize;
        this.title.setPosition(0, 0).setSize(this.width, headerSize);
        this.scrollList.setPosition(0, headerSize);
        this.scrollList.setSize(listWidth, listHeight);
        this.scrollListBackground.setPositionAndSize(this.scrollList);
        this.scrollBar.setPosition(this.scrollList.posX + this.scrollList.width, this.scrollList.posY);
        this.scrollBar.height = this.scrollList.height;
        int x1 = this.width / 2 - 100;
        int y1 = this.height - headerSize / 2 - 10;
        int p = 4;
        this.selectButton.setPosition(x1, y1);
        int i = 0;
        while (i < this.channelCheckboxes.size()) {
            GuiCheckbox checkbox = this.channelCheckboxes.get(i);
            checkbox.setPosition(this.scrollList.posX + this.scrollList.width + this.scrollBar.width + p, this.scrollList.posY + i * (20 + p));
            checkbox.width = 100;
            ++i;
        }
        super.onResize();
    }

    @Override
    public void actionPerformed(GuiElement source) {
        if (source == this.selectButton) {
            this.consumer.accept(this.selectedVersion);
        }
        if (source instanceof ChannelCheckbox) {
            ChannelCheckbox checkbox = (ChannelCheckbox)source;
            enabledChannels.put(checkbox.channel, checkbox.isChecked());
            this.updateVersionList();
            this.onResize();
        }
    }

    @Override
    public boolean keyEvent(int key, boolean pressed) {
        if (super.keyEvent(key, pressed)) {
            return true;
        }
        if ((key == 10 || key == 32) && pressed) {
            this.consumer.accept(this.selectedVersion);
            return true;
        }
        return false;
    }

    @Override
    public void focusChanged(Focusable focusable) {
        if (focusable.isFocused() && focusable instanceof VersionButton) {
            VersionButton versionButton = (VersionButton)focusable;
            this.selectedVersion = versionButton.version;
            this.selectButton.setClickable(this.selectedVersion != null);
        }
        super.focusChanged(focusable);
    }

    class ChannelCheckbox
    extends GuiCheckbox {
        public final Versions.Channel channel;

        public ChannelCheckbox(GuiScreen screen, Versions.Channel channel) {
            super(screen, channel.getDisplayName());
            this.channel = channel;
        }
    }

    class VersionButton
    extends GuiListButton {
        public final Versions.Version version;

        public VersionButton(GuiScreen screen, Versions.Version version) {
            super(screen);
            this.version = version;
            this.text = version.getDisplayName();
        }
    }
}

