/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.screen.multimc;

import b100.installer.gui.modern.element.GuiButton;
import b100.installer.gui.modern.element.GuiDialog;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.element.GuiTextElement;
import b100.installer.gui.modern.screen.GuiFileChooser;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.screen.multimc.GuiInstallMultiMC;
import b100.installer.gui.modern.util.ActionListener;
import b100.installer.util.MultiMCHelper;
import java.io.File;

public class GuiChooseMultiMCFolder
extends GuiFileChooser
implements ActionListener {
    public GuiChooseMultiMCFolder(GuiScreen parentScreen) {
        super(parentScreen);
        this.fileFilter = file -> file.isDirectory();
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.buttonOpen.addActionListener(this);
        GuiDialog info = new GuiDialog(this);
        info.add(new GuiTextElement().setText("Please select the MultiMC / Prism Launcher folder.").setAutoSize(true));
        GuiButton closeButton = new GuiButton(this, "Ok");
        closeButton.addActionListener(e -> info.close());
        closeButton.width = 150;
        info.add(closeButton);
        this.add(info);
    }

    @Override
    public void actionPerformed(GuiElement source) {
        if (source == this.buttonOpen) {
            File launcherDirectory = this.getSelectedFile();
            if (launcherDirectory == null) {
                GuiDialog info = new GuiDialog(this);
                info.add(new GuiTextElement().setText("Please select a folder!").setAutoSize(true));
                GuiButton closeButton = new GuiButton(this, "Ok");
                closeButton.addActionListener(e -> info.close());
                closeButton.width = 150;
                info.add(closeButton);
                this.add(info);
                return;
            }
            MultiMCHelper.setLauncherDirectory(launcherDirectory);
            File instancesDirectory = MultiMCHelper.getInstancesDirectory();
            if (instancesDirectory == null) {
                GuiDialog info = new GuiDialog(this);
                info.add(new GuiTextElement().setText("Couldn't find an instances folder in\n'" + launcherDirectory.getAbsolutePath() + "'!").setAutoSize(true));
                GuiButton closeButton = new GuiButton(this, "Ok");
                closeButton.addActionListener(e -> info.close());
                closeButton.width = 150;
                info.add(closeButton);
                this.add(info);
                return;
            }
            this.setScreen(new GuiInstallMultiMC(this.parentScreen, launcherDirectory));
        }
    }
}

