/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.screen.multimc;

import b100.installer.gui.modern.element.GuiButton;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.element.GuiListButton;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.screen.GuiScrollListScreen;
import b100.installer.gui.modern.util.ActionListener;
import b100.installer.util.MultiMCHelper;
import b100.json.JsonParser;
import b100.json.element.JsonArray;
import b100.json.element.JsonElement;
import b100.json.element.JsonEntry;
import b100.json.element.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class GuiSelectInstance
extends GuiScrollListScreen
implements ActionListener {
    private static final String DEFAULT_GROUP_ID = "_DEFAULT_";
    public File instancesFolder;
    public Consumer<String> consumer;
    public GuiButton selectButton;
    public String selectedInstance;

    public GuiSelectInstance(GuiScreen parentScreen, File instancesFolder, Consumer<String> consumer, String initialSelection) {
        super(parentScreen);
        this.instancesFolder = instancesFolder;
        this.consumer = consumer;
        this.selectedInstance = initialSelection;
        this.title = "Select Instance";
    }

    @Override
    protected void onInit() {
        this.selectButton = new GuiButton(this, "Select");
        this.selectButton.setClickable(false);
        this.selectButton.addActionListener(this);
        super.onInit();
        this.add(this.selectButton);
    }

    @Override
    public void initScrollElements() {
        Object groupName;
        ArrayList<Object> allInstanceGroups = new ArrayList<Object>();
        HashMap<String, File[]> instanceToGroupMap = new HashMap<String, File[]>();
        HashMap<String, ArrayList<String>> groupToInstancesMap = new HashMap<String, ArrayList<String>>();
        allInstanceGroups.add(DEFAULT_GROUP_ID);
        File instgroupsFile = new File(this.instancesFolder, "instgroups.json");
        if (instgroupsFile.isFile()) {
            JsonObject jsonObject = ((JsonObject)JsonParser.instance.parseFileContent(instgroupsFile)).getObject("groups");
            for (JsonEntry entry : jsonObject) {
                groupName = entry.name;
                allInstanceGroups.add(groupName);
                JsonArray instancesInGroup = entry.value.getAsObject().getArray("instances");
                for (JsonElement element : instancesInGroup) {
                    instanceToGroupMap.put(element.getAsString().value, (File[])groupName);
                }
            }
        }
        groupName = this.instancesFolder.listFiles();
        int n = ((File[])groupName).length;
        int n2 = 0;
        while (n2 < n) {
            File file = groupName[n2];
            if (MultiMCHelper.isInstance(file)) {
                ArrayList<String> instancesInGroup;
                String instanceName = file.getName();
                String instanceGroup = (String)instanceToGroupMap.get(instanceName);
                if (instanceGroup == null) {
                    instanceGroup = DEFAULT_GROUP_ID;
                }
                if ((instancesInGroup = (ArrayList<String>)groupToInstancesMap.get(instanceGroup)) == null) {
                    instancesInGroup = new ArrayList<String>();
                    groupToInstancesMap.put(instanceGroup, instancesInGroup);
                }
                instancesInGroup.add(instanceName);
            }
            ++n2;
        }
        for (String string : allInstanceGroups) {
            List instancesInGroup;
            if (!DEFAULT_GROUP_ID.equals(string)) {
                this.scrollList.add(new GroupElement(string));
            }
            if ((instancesInGroup = (List)groupToInstancesMap.get(string)) == null) continue;
            for (String instanceName : instancesInGroup) {
                File instanceFolder = new File(this.instancesFolder, instanceName);
                InstanceElement element = new InstanceElement(this, instanceFolder);
                this.scrollList.add(element);
                if (this.selectedInstance == null || !this.selectedInstance.equals(instanceFolder.getName())) continue;
                element.setFocused(true);
            }
        }
    }

    @Override
    public void onResize() {
        super.onResize();
        int x1 = this.width / 2 - 100;
        int y1 = this.height - this.headerSize / 2 - 10;
        this.selectButton.setPosition(x1, y1);
    }

    @Override
    public void actionPerformed(GuiElement source) {
        if (source == this.selectButton) {
            this.consumer.accept(this.selectedInstance);
        }
    }

    class GroupElement
    extends GuiElement {
        public String groupName;

        public GroupElement(String groupName) {
            this.groupName = groupName;
            this.setSize(200, 20);
        }

        @Override
        public void draw() {
            int x1 = this.posX + this.width / 2;
            int y1 = this.posY + this.height / 2 - 4;
            this.fontRenderer.drawCenteredString(this.groupName, x1, y1, 0x808080, true);
        }
    }

    class InstanceElement
    extends GuiListButton {
        public File instanceFolder;
        public String instanceName;

        public InstanceElement(GuiScreen screen, File instanceFolder) {
            super(screen);
            this.instanceFolder = instanceFolder;
            try {
                this.instanceName = MultiMCHelper.getInstanceName(instanceFolder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.instanceName == null) {
                this.instanceName = instanceFolder.getName();
            }
            this.height = 24;
        }

        @Override
        public void draw() {
            super.draw();
            int x0 = this.posX + 3;
            int y0 = this.posY + 3;
            this.fontRenderer.drawString(this.instanceName, x0, y0, 0xFFFFFF, true);
            this.fontRenderer.drawString(this.instanceFolder.getName(), x0, y0 + 10, 0x808080, true);
        }

        @Override
        public void onFocusChanged() {
            super.onFocusChanged();
            if (this.isFocused()) {
                GuiSelectInstance.this.selectedInstance = this.instanceFolder.getName();
                GuiSelectInstance.this.selectButton.setClickable(GuiSelectInstance.this.selectedInstance != null);
            }
        }
    }
}

