/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.util;

import b100.installer.gui.modern.element.GuiContainer;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.util.FocusDirection;
import b100.installer.gui.modern.util.FocusListener;
import b100.installer.gui.modern.util.ListenerList;
import java.util.function.Function;

public interface Focusable {
    public static final Function<GuiElement, Boolean> FOCUSABLE_CONDITION = element -> Focusable.isFocusable(element);

    public void setFocused(boolean var1);

    public boolean isFocused();

    public boolean isFocusable();

    public ListenerList<FocusListener> getFocusListeners();

    public GuiContainer getContainer();

    public static boolean isFocusable(GuiElement element) {
        if (element instanceof Focusable) {
            Focusable focusable = (Focusable)((Object)element);
            return focusable.isFocusable();
        }
        return false;
    }

    public static Focusable findNextFocusableElement(GuiElement element, FocusDirection direction) {
        try {
            return Focusable.findNextFocusableElementDo(element, direction);
        }
        catch (CancelAction e) {
            return null;
        }
    }

    public static Focusable findNextFocusableElementDo(GuiElement element, FocusDirection direction) throws CancelAction {
        GuiContainer container = element.getContainer();
        if (container == null) {
            return null;
        }
        Focusable next = container.getNextFocusable(element, direction);
        if (next != null) {
            return next;
        }
        if (direction.isArrowKey() && container.isListContainer()) {
            throw new CancelAction();
        }
        return Focusable.findNextFocusableElementDo(container, direction);
    }

    public static class CancelAction
    extends Exception {
    }
}

