/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.installer;

import b100.installer.Config;
import b100.installer.DownloadHelper;
import b100.installer.Versions;
import b100.installer.installer.Installer;
import b100.installer.installer.ProgressListener;
import b100.installer.util.ModLoader;
import b100.installer.util.Utils;
import b100.json.JsonParser;
import b100.json.element.JsonElement;
import b100.json.element.JsonObject;
import b100.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.swing.JOptionPane;

public class VanillaLauncherInstaller
implements Installer {
    @Override
    public boolean install(Map<String, Object> parameters, ProgressListener progressListener) {
        String jsonPath;
        File outputJar;
        JsonObject fabricObject;
        String selectedVersion = (String)parameters.get("version");
        ModLoader loader = (ModLoader)((Object)parameters.get("loader"));
        File minecraftDirectory = new File((String)parameters.get("mcdir"));
        System.out.println("Selected Version: " + selectedVersion);
        System.out.println("Selected Mod Loader: " + (Object)((Object)loader));
        System.out.println("Minecraft Directory: " + minecraftDirectory.getAbsolutePath());
        Config config = Config.getInstance();
        config.lastSelectedVersion.value = selectedVersion;
        config.lastInstallType.value = "vanilla";
        config.lastMinecraftDirectory.value = minecraftDirectory.getAbsolutePath();
        config.save();
        if (!minecraftDirectory.exists() || !minecraftDirectory.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Invalid Minecraft Directory: '" + minecraftDirectory.getAbsolutePath() + "'!");
            config.lastMinecraftDirectory = null;
            config.save();
            return false;
        }
        Versions.Version version = Versions.getInstance().get(selectedVersion);
        JsonObject manifest = version.manifest;
        JsonObject vanillaObject = manifest.getObject("vanilla");
        if (vanillaObject == null) {
            throw new NullPointerException("No vanilla object!");
        }
        String versionName = "BTA " + selectedVersion;
        String profileName = "Better Than Adventure!";
        if (loader == ModLoader.Fabric || loader == ModLoader.Babric) {
            versionName = String.valueOf(versionName) + " " + loader.name();
            profileName = String.valueOf(profileName) + " " + selectedVersion + " " + loader.name();
        } else if (loader != ModLoader.None) {
            profileName = String.valueOf(profileName) + " " + loader.name();
        }
        String fabricVersionOverride = null;
        if ((loader == ModLoader.Fabric || loader == ModLoader.Babric) && (fabricVersionOverride = (fabricObject = manifest.getObject("fabric")) != null && fabricObject.has("version-name-override") ? fabricObject.getString("version-name-override") : selectedVersion) == null) {
            JOptionPane.showMessageDialog(null, "The selected version does not support Fabric!");
            return false;
        }
        File versionFolder = new File(minecraftDirectory, "versions/" + versionName);
        if (!versionFolder.exists()) {
            versionFolder.mkdirs();
        }
        if (!(outputJar = new File(versionFolder, String.valueOf(versionName) + ".jar")).exists()) {
            System.out.println("Version is not installed");
            File minecraftJar = new File(minecraftDirectory, "versions/b1.7.3/b1.7.3.jar");
            if (!minecraftJar.exists()) {
                JOptionPane.showMessageDialog(null, "Please start Beta 1.7.3 once before installing!");
                return false;
            }
            File btaJarFile = version.getFile("client.jar", progressListener);
            Utils.createModdedMinecraftJar(minecraftJar, btaJarFile, outputJar);
        } else {
            System.out.println("Version is installed");
        }
        if (loader == ModLoader.Fabric || loader == ModLoader.Babric) {
            JsonElement jsonFabric = vanillaObject.get("json-" + loader.name().substring(0, 1).toLowerCase() + "abric");
            if (jsonFabric == null) {
                JOptionPane.showMessageDialog(null, "The selected version does not support " + loader.name() + "!");
                return false;
            }
            jsonPath = jsonFabric.getAsString().value;
        } else {
            jsonPath = vanillaObject.getString("json");
        }
        JsonObject json = DownloadHelper.getJson("misc/vanilla/" + jsonPath);
        json.set("id", versionName);
        StringUtils.saveStringToFile(new File(versionFolder, String.valueOf(versionName) + ".json"), json.toString());
        this.updateLauncherProfile(minecraftDirectory, profileName, versionName, loader, fabricVersionOverride);
        JOptionPane.showMessageDialog(null, "Done!");
        return true;
    }

    public void updateLauncherProfile(File minecraftDirectory, String profileName, String versionId, ModLoader loader, String fabricVersionOverride) {
        File launcherProfilesFile = new File(minecraftDirectory, "launcher_profiles.json");
        JsonObject root = (JsonObject)JsonParser.instance.parseFileContent(launcherProfilesFile);
        JsonObject profiles = root.getObject("profiles");
        JsonObject profile = null;
        int i = 0;
        while (i < profiles.entryList().size()) {
            JsonObject profile1 = profiles.entryList().get((int)i).value.getAsObject();
            String profileName1 = profile1.getString("name");
            if (profileName1.equals(profileName)) {
                System.out.println("Installing into launcher profile '" + profileName1 + "'!");
                profile = profile1;
                break;
            }
            ++i;
        }
        if (profile == null) {
            System.out.println("Creating new launcher profile: '" + profileName + "'!");
            String randomUUID = UUID.randomUUID().toString().toLowerCase().replace("-", "");
            System.out.println("UUID: " + randomUUID);
            profile = new JsonObject();
            profiles.set(randomUUID, profile);
        }
        profile.set("lastVersionId", versionId);
        profile.set("name", profileName);
        profile.set("icon", "Grass");
        if (!profile.has("created")) {
            profile.set("created", "1970-01-01T00:00:00.000Z");
        }
        profile.set("lastUsed", "2070-01-01T00:00:00.000Z");
        profile.set("type", "custom");
        ArrayList<String> javaArgs = new ArrayList<String>();
        if ((loader == ModLoader.Fabric || loader == ModLoader.Babric) && fabricVersionOverride != null) {
            javaArgs.add("-Dfabric.gameVersion=" + fabricVersionOverride);
        }
        if (loader == ModLoader.ASMLoader) {
            JOptionPane.showMessageDialog(null, "ASMLoader installation is currently not implemented!");
        }
        profile.set("javaArgs", Utils.combineStringsSeperatedWithSpaces(javaArgs));
        StringUtils.saveStringToFile(launcherProfilesFile, root.toString());
    }

    @Override
    public boolean isCompatible(String version, ModLoader loader) {
        JsonObject manifest = Versions.getInstance().get((String)version).manifest;
        if (loader == ModLoader.Fabric || loader == ModLoader.Babric) {
            JsonObject versionObject = manifest.getObject(version);
            if (loader == ModLoader.Babric) {
                return versionObject.getObject("vanilla").has("json-babric");
            }
            return versionObject.getObject("vanilla").has("json-fabric");
        }
        if (loader == ModLoader.ASMLoader) {
            return false;
        }
        return loader == ModLoader.None;
    }
}

