/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;

public class Log {
    private static PrintStream previousOut;
    private static PrintStream previousErr;
    private static PrintStream customOut;
    private static PrintStream customErr;
    private static OutputStream out;
    private static OutputStreamWriter writer;
    private static boolean isSetup;

    public static void setup(File logFile) {
        if (isSetup) {
            Log.close();
        }
        try {
            previousOut = System.out;
            previousErr = System.err;
            logFile = logFile.getAbsoluteFile();
            File parent = logFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            out = new FileOutputStream(logFile);
            writer = new OutputStreamWriter(out);
            customOut = new LogPrintStream(System.out, "[OUT] ");
            customErr = new LogPrintStream(System.err, "[ERR] ");
            isSetup = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up log: " + logFile.getAbsolutePath());
        }
    }

    public static void enable() {
        if (!isSetup) {
            throw new RuntimeException("Log is not set up!");
        }
        System.setOut(customOut);
        System.setErr(customErr);
    }

    public static void disable() {
        if (!isSetup) {
            throw new RuntimeException("Log is not set up!");
        }
        System.setOut(previousOut);
        System.setErr(previousErr);
    }

    public static void close() {
        if (!isSetup) {
            return;
        }
        System.setOut(previousOut);
        System.setErr(previousErr);
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        out = null;
        writer = null;
        isSetup = false;
    }

    static class LogPrintStream
    extends PrintStream {
        private String name;
        private PrintStream previous;
        private boolean lineBreak = true;

        public LogPrintStream(PrintStream stream, String name) {
            super(stream);
            this.previous = stream;
            this.name = name;
        }

        @Override
        public void println(String str) {
            this.printlnImpl(str);
        }

        @Override
        public void println(boolean x) {
            this.printlnImpl(String.valueOf(x));
        }

        @Override
        public void println(char x) {
            this.printlnImpl(String.valueOf(x));
        }

        @Override
        public void println(char[] x) {
            this.printlnImpl(new String(x));
        }

        @Override
        public void println(double x) {
            this.printlnImpl(String.valueOf(x));
        }

        @Override
        public void println(float x) {
            this.printlnImpl(String.valueOf(x));
        }

        @Override
        public void println(int x) {
            this.printlnImpl(String.valueOf(x));
        }

        @Override
        public void println(long x) {
            this.printlnImpl(String.valueOf(x));
        }

        @Override
        public void println(Object x) {
            this.printlnImpl(String.valueOf(x));
        }

        public void printlnImpl(String str) {
            this.printImpl(String.valueOf(str) + "\n");
        }

        @Override
        public void println() {
            this.printlnImpl("");
        }

        @Override
        public void print(String str) {
            this.printImpl(str);
        }

        public void printImpl(String str) {
            StringBuilder strb = new StringBuilder();
            try {
                int i = 0;
                while (i < str.length()) {
                    char c = str.charAt(i);
                    if (this.lineBreak) {
                        strb.append(this.name);
                        this.lineBreak = false;
                    }
                    if (c == '\t') {
                        strb.append("    ");
                    } else {
                        if (c == '\n') {
                            this.lineBreak = true;
                        }
                        strb.append(c);
                    }
                    ++i;
                }
                str = strb.toString();
                writer.write(str);
                writer.flush();
                this.previous.print(str);
            }
            catch (Exception e) {
                Log.disable();
                e.printStackTrace();
            }
        }
    }
}

