/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.util;

import b100.installer.Download;
import b100.installer.Global;
import b100.installer.Main;
import b100.installer.installer.ProgressListener;
import b100.utils.FileUtils;
import b100.utils.StreamUtils;
import b100.utils.StringUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;

public abstract class Utils {
    public static final int OS_WINDOWS = 0;
    public static final int OS_MAC = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_UNKNOWN = 3;
    public static final int OPERATING_SYSTEM;

    static {
        int os = 3;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            os = 0;
        }
        if (osName.contains("mac")) {
            os = 1;
        }
        if (osName.contains("linux") || osName.contains("unix") || osName.contains("sunos") || osName.contains("solaris")) {
            os = 2;
        }
        OPERATING_SYSTEM = os;
    }

    public static File getMinecraftDirectory() {
        return Utils.getAppDirectory("minecraft");
    }

    public static File getAppDirectory(String appName) {
        String appdata;
        String userHome = System.getProperty("user.home", ".");
        File appDir = OPERATING_SYSTEM == 2 ? new File(userHome, "." + appName + "/") : (OPERATING_SYSTEM == 0 ? ((appdata = System.getenv("APPDATA")) != null ? new File(appdata, "." + appName + "/") : new File(userHome, "." + appName + "/")) : (OPERATING_SYSTEM == 1 ? new File(userHome, "Library/Application Support/" + appName + "/") : new File(userHome, String.valueOf(appName) + "/")));
        return appDir;
    }

    public static void createNewFile(File file) {
        if (file.exists()) {
            file.delete();
        } else {
            File parent = file.getAbsoluteFile().getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create file: '" + file.getAbsolutePath() + "'!", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void createModdedMinecraftJar(File minecraftJar, File modJar, File output) {
        Utils.createNewFile(output);
        closeables = new ArrayList<Closeable>();
        out = null;
        files = new ArrayList<File>();
        files.add(minecraftJar);
        files.add(modJar);
        try {
            try {
                out = new ZipOutputStream(new FileOutputStream(output));
                closeables.add(out);
                addedEntries = new HashSet<String>();
                i = files.size() - 1;
                while (i >= 0) {
                    file = (File)files.get(i);
                    zip = new ZipFile(file);
                    closeables.add(zip);
                    entries = zip.entries();
                    while (entries.hasMoreElements()) {
                        entry = entries.nextElement();
                        entryName = entry.getName();
                        if (i == 0 && entryName.startsWith("META-INF") || addedEntries.contains(entryName)) continue;
                        allBytes = Utils.readAll(zip.getInputStream(entry));
                        out.putNextEntry(new ZipEntry(entryName));
                        out.write(allBytes);
                        addedEntries.add(entryName);
                    }
                    --i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            i = 0;
            ** while (i < closeables.size())
        }
lbl-1000:
        // 1 sources

        {
            try {
                ((Closeable)closeables.get(i)).close();
            }
            catch (Exception var16_19) {
                // empty catch block
            }
            ++i;
            continue;
        }
lbl47:
        // 1 sources

    }

    public static void downloadFileAndPrintProgress(String url, File file) {
        new Download(url).setPrintProgress(true).downloadIntoFile(file);
    }

    public static byte[] readAll(InputStream inputStream) throws IOException {
        byte[] cache;
        int read;
        int cacheSize = 4096;
        ByteCache byteCache = new ByteCache();
        while ((read = inputStream.read(cache = new byte[4096], 0, cache.length)) != -1) {
            byteCache.put(cache, 0, read);
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteCache.getAll();
    }

    public static String[] toArray(List<String> list) {
        String[] array = new String[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    public static BufferedImage readImage(String path) {
        InputStream stream = null;
        try {
            stream = Utils.class.getResourceAsStream(path);
            BufferedImage bufferedImage = ImageIO.read(stream);
            return bufferedImage;
        }
        catch (Exception e) {
            throw new RuntimeException("Reading image: '" + path + "'!");
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void copyFile(File from, File to, ProgressListener progressListener) {
        FileUtils.createFolderForFile(to);
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                int read;
                in = new FileInputStream(from);
                out = new FileOutputStream(to);
                byte[] temp = new byte[1024];
                long copiedAmount = 0L;
                long totalAmount = from.length();
                while ((read = in.read(temp)) != -1) {
                    out.write(temp, 0, read);
                    copiedAmount += (long)read;
                    if (progressListener == null) continue;
                    float progress = (float)((double)copiedAmount / (double)totalAmount);
                    progressListener.setProgress(progress);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Copying file from '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'!", e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Map<String, String> loadProperties(File file) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String[] lines = StringUtils.getFileContentAsString(file).split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            int j = line.indexOf(58);
            if (j != -1) {
                properties.put(line.substring(0, j), line.substring(j + 1));
            }
            ++i;
        }
        return properties;
    }

    public static String combineStringsSeperatedWithSpaces(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder argsStr = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                argsStr.append(' ');
            }
            argsStr.append(list.get(i));
            ++i;
        }
        return argsStr.toString();
    }

    public static <E> int indexOf(E[] array, E obj) {
        int i = 0;
        while (i < array.length) {
            if (obj.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E> int indexOf(List<E> list, E obj) {
        int i = 0;
        while (i < list.size()) {
            if (obj.equals(list.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getClipboardString() {
        try {
            Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (trans != null && trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String s = (String)trans.getTransferData(DataFlavor.stringFlavor);
                return s;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void copyString(String text) {
        try {
            StringSelection selection = new StringSelection(text);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void extractFile(String internalPath, File output) {
        File parent = output.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = Utils.class.getResourceAsStream(internalPath);
                if (in == null) {
                    throw new NullPointerException("Resource does not exist: \"" + internalPath + "\"!");
                }
                out = new FileOutputStream(output);
                StreamUtils.transferData(in, out);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not extract file from \"" + internalPath + "\" to " + output.getAbsolutePath(), e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static List<String> splitLines(String string) {
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        int i = string.indexOf(10, start);
        while (true) {
            if (i == -1) break;
            lines.add(string.substring(start, i));
            start = i + 1;
            i = string.indexOf(10, start);
        }
        lines.add(string.substring(start, string.length()));
        return lines;
    }

    public static void createAndRunThread(String name, boolean daemon, Runnable runnable) {
        Thread thread = new Thread(runnable);
        if (name != null) {
            thread.setName(name);
        }
        thread.setDaemon(daemon);
        thread.start();
    }

    public static String getEscapedPath(File file) {
        return "\"" + file.getAbsolutePath() + "\"";
    }

    public static void copyFile(File from, File to) {
        File parent = to.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(from);
                out = new FileOutputStream(to);
                Utils.copy(in, out);
            }
            catch (Exception e) {
                throw new RuntimeException("Copying file from \"" + from.getAbsolutePath() + "\" to \"" + to + "\"!", e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] cache = new byte[1024];
        while ((read = in.read(cache)) >= 0) {
            out.write(cache, 0, read);
        }
    }

    public static Process startProcess(List<String> cmd) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.inheritIO();
            return processBuilder.start();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static File getFileFromURL(String urlString) {
        try {
            URL url = new URL(urlString);
            URI uri = url.toURI();
            return new File(uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readVersion() {
        return Utils.readLine(Main.class.getResourceAsStream("/version.txt"));
    }

    public static List<String> getInstallerAndSystemInfo() {
        ArrayList<String> infos = new ArrayList<String>();
        try {
            infos.add("Installer Version: " + Global.VERSION);
            infos.add("Installer Directory: '" + Global.getInstallerDirectory().getAbsolutePath() + "'");
            infos.add("Offline Mode: " + Global.isOffline());
            infos.add("Operating System: " + System.getProperty("os.name"));
            infos.add("Java Version: " + System.getProperty("java.version"));
        }
        catch (Exception e) {
            String msg = "Could not get debug information!";
            infos.add(msg);
            System.err.println(msg);
            e.printStackTrace();
        }
        return infos;
    }

    public static String readLine(InputStream in) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(in));
            String string = br.readLine();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void getDirFromArgs(String name, String[] args, int i, Consumer<File> consumer) {
        if (args.length <= i) {
            System.out.println("Didn't receive path after \"" + args[i - 1] + "\"!");
            return;
        }
        String arg = args[i];
        File file = new File(arg);
        if (file.isDirectory()) {
            System.out.println(String.valueOf(name) + " in args: " + file.getAbsolutePath());
            consumer.accept(file);
        } else {
            System.out.println("Received invalid " + name.toLowerCase() + " in args: \"" + arg + "\"");
        }
    }

    public static int floor(double d) {
        return (int)Math.floor(d);
    }

    public static int ceil(double d) {
        return (int)Math.ceil(d);
    }

    public static int ceilDiv(int a, int b) {
        return (int)Math.ceil((double)a / (double)b);
    }

    public static int clampi(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static double clampd(double val, double min, double max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static long clampl(long val, long min, long max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static int multiplyRGB(int color, double mul) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        r = (int)((double)r * mul);
        g = (int)((double)g * mul);
        b = (int)((double)b * mul);
        a = Utils.clampi(a, 0, 255);
        r = Utils.clampi(r, 0, 255);
        g = Utils.clampi(g, 0, 255);
        b = Utils.clampi(b, 0, 255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int mixARGB(int color1, int color2, float factor) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 >> 0 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 >> 0 & 0xFF;
        int a = Utils.mix(a1, a2, factor);
        int r = Utils.mix(r1, r2, factor);
        int g = Utils.mix(g1, g2, factor);
        int b = Utils.mix(b1, b2, factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int mix(int a, int b, float factor) {
        return (int)((float)a * (1.0f - factor) + (float)b * factor);
    }

    static class ByteCache {
        private List<CacheEntry> allBuffers = new ArrayList<CacheEntry>();

        ByteCache() {
        }

        public void put(byte[] bytes, int offset, int length) {
            CacheEntry cacheEntry = new CacheEntry();
            cacheEntry.bytes = bytes;
            cacheEntry.length = length;
            cacheEntry.offset = offset;
            this.allBuffers.add(cacheEntry);
        }

        public byte[] getAll() {
            int totalSize = 0;
            int buffers = this.allBuffers.size();
            int i = 0;
            while (i < buffers) {
                totalSize += this.allBuffers.get((int)i).length;
                ++i;
            }
            byte[] allBytes = new byte[totalSize];
            int offset = 0;
            int i2 = 0;
            while (i2 < buffers) {
                CacheEntry cacheEntry = this.allBuffers.get(i2);
                byte[] bytes = cacheEntry.bytes;
                int j = 0;
                while (j < cacheEntry.length) {
                    allBytes[offset + j] = bytes[cacheEntry.offset + j];
                    ++j;
                }
                offset += cacheEntry.length;
                ++i2;
            }
            return allBytes;
        }

        static class CacheEntry {
            public byte[] bytes;
            public int offset;
            public int length;

            CacheEntry() {
            }
        }
    }
}

