/*
 * Decompiled with CFR 0.152.
 */
package b100.json.element;

import b100.json.element.JsonElement;
import b100.json.element.JsonNumber;
import b100.utils.ArrayIterator;
import b100.utils.InvalidCharacterException;
import b100.utils.StringReader;
import b100.utils.StringWriter;
import b100.utils.Utils;
import b100.utils.interfaces.Condition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonArray
implements JsonElement,
Iterable<JsonElement> {
    private JsonElement[] elements;
    private boolean compact;

    public JsonArray(int length) {
        this.compact = false;
        this.elements = new JsonElement[length];
    }

    public JsonArray(JsonElement[] elements) {
        this.compact = false;
        this.elements = elements;
    }

    public JsonArray(List<JsonElement> list) {
        this.compact = false;
        this.elements = Utils.toArray(JsonElement.class, list);
    }

    public JsonArray(StringReader reader) {
        ArrayList<JsonElement> elementsList;
        block4: {
            this.compact = false;
            elementsList = new ArrayList<JsonElement>();
            reader.skipWhitespace();
            reader.expectAndSkip('[');
            while (true) {
                reader.skipWhitespace();
                if (reader.get() == ']') {
                    reader.next();
                    break block4;
                }
                elementsList.add(JsonElement.readElement(reader));
                reader.skipWhitespace();
                if (reader.get() != ',') break;
                reader.next();
            }
            if (reader.get() == ']') {
                reader.next();
            } else {
                throw new InvalidCharacterException(reader);
            }
        }
        this.elements = Utils.toArray(JsonElement.class, elementsList);
    }

    public JsonElement query(Condition<JsonElement> condition) {
        JsonElement[] jsonElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            JsonElement e = jsonElementArray[n2];
            if (condition.isTrue(e)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return "JsonArray: " + this.elements.length + " elements";
    }

    @Override
    public void write(StringWriter writer) {
        if (this.elements.length == 0) {
            writer.write("[]");
            return;
        }
        if (this.isCompact()) {
            writer.write("[ ");
        } else {
            writer.writeln("[");
        }
        writer.addTab();
        int i = 0;
        JsonElement[] jsonElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            JsonElement element = jsonElementArray[n2];
            element.write(writer);
            if (i < this.elements.length - 1) {
                writer.write(", ");
            }
            if (!this.isCompact()) {
                writer.write('\n');
            }
            ++i;
            ++n2;
        }
        writer.removeTab();
        if (this.isCompact()) {
            writer.write(" ]");
        } else {
            writer.write("]");
        }
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return new ArrayIterator<JsonElement>(this.elements);
    }

    public int length() {
        return this.elements.length;
    }

    public JsonElement get(int i) {
        return this.elements[i];
    }

    public JsonArray set(int i, JsonElement element) {
        this.elements[i] = element;
        return this;
    }

    public JsonArray set(int i, Number number) {
        this.elements[i] = new JsonNumber(number);
        return this;
    }

    public JsonArray setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    public boolean isCompact() {
        return this.compact;
    }
}

