/*
 * Decompiled with CFR 0.152.
 */
package b100.json.element;

import b100.json.element.JsonElement;
import b100.utils.InvalidCharacterException;
import b100.utils.StringReader;
import b100.utils.StringWriter;

public class JsonString
implements JsonElement {
    public String value;

    public JsonString(String value) {
        this.value = value;
    }

    public JsonString(StringReader reader) {
        StringBuilder builder = new StringBuilder();
        reader.expectAndSkip('\"');
        while (true) {
            if (reader.get() == '\"') break;
            if (reader.get() == '\\') {
                reader.next();
                char next = reader.get();
                if (next == 'n' || next == 'N') {
                    builder.append('\n');
                } else {
                    if (next == 'u' || next == 'U') {
                        int charIndex;
                        reader.next();
                        String hex = reader.get(4);
                        try {
                            charIndex = Integer.parseInt(hex, 16);
                        }
                        catch (NumberFormatException e) {
                            throw new InvalidCharacterException(reader, "Invalid hex code \"" + hex + "\"");
                        }
                        builder.append((char)charIndex);
                        reader.skip(4);
                        continue;
                    }
                    if (next == '\\') {
                        builder.append('\\');
                    } else {
                        throw new InvalidCharacterException(reader);
                    }
                }
                reader.next();
                continue;
            }
            builder.append(reader.getAndSkip());
        }
        reader.next();
        this.value = builder.toString();
    }

    public boolean equals(JsonString string2) {
        return this.value.equals(string2.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void write(StringWriter writer) {
        writer.write("\"");
        int i = 0;
        while (i < this.value.length()) {
            char c = this.value.charAt(i);
            if (c == '\n') {
                writer.write("\\n");
            } else if (c == '\t') {
                writer.write("\\t");
            } else if (c == '\\') {
                writer.write("\\\\");
            } else {
                writer.write(c);
            }
            ++i;
        }
        writer.write("\"");
    }
}

