/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.config;

import b100.installer.config.ConfigUtil;
import b100.installer.config.Property;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigFile
implements ConfigUtil.ConfigParser {
    public File file;
    private final List<Property> allProperties = new ArrayList<Property>();
    private final Map<String, Property> propertyMap = new HashMap<String, Property>();
    private final List<Property> allPropertiesImmutable = Collections.unmodifiableList(this.allProperties);

    public ConfigFile(File file) {
        this.file = file;
    }

    @Override
    public void parse(String key, String value) {
        Property property = this.propertyMap.get(key);
        if (property == null) {
            System.out.println("Unknown Config Property: " + key);
            return;
        }
        property.parseConfigString(value);
    }

    public <E extends Property> E register(String name, E property) {
        this.allProperties.add(property);
        this.propertyMap.put(name, property);
        return property;
    }

    public void load() {
        if (this.file.exists()) {
            ConfigUtil.loadConfig(this.file, (ConfigUtil.ConfigParser)this, ':');
        }
    }

    public void save() {
        StringBuilder str = new StringBuilder();
        Map<Property, String> propertyKeys = this.getPropertyKeyMap();
        int written = 0;
        int i = 0;
        while (i < this.allProperties.size()) {
            Property property = this.allProperties.get(i);
            String key = propertyKeys.get(property);
            String value = property.getConfigString();
            if (key != null && value != null) {
                if (written > 0) {
                    str.append('\n');
                }
                str.append(key);
                str.append(':');
                str.append(value);
                ++written;
            }
            ++i;
        }
        ConfigUtil.saveStringToFile(str.toString(), this.file);
    }

    public List<Property> getAllProperties() {
        return this.allPropertiesImmutable;
    }

    public Property getProperty(String name) {
        return this.propertyMap.get(name);
    }

    public List<String> getAllPropertyKeys() {
        Map<Property, String> propertyKeys = this.getPropertyKeyMap();
        ArrayList<String> allKeys = new ArrayList<String>();
        int i = 0;
        while (i < this.allProperties.size()) {
            allKeys.add(propertyKeys.get(this.allProperties.get(i)));
            ++i;
        }
        return Collections.unmodifiableList(allKeys);
    }

    public Map<Property, String> getPropertyKeyMap() {
        HashMap<Property, String> propertyKeys = new HashMap<Property, String>();
        for (String key : this.propertyMap.keySet()) {
            Property property = this.propertyMap.get(key);
            propertyKeys.put(property, key);
        }
        return propertyKeys;
    }
}

